package com.xforceplus.ant.coop.rule.center.client.api.cc;

import com.xforceplus.ant.coop.rule.center.client.data.cc.request.UpdateBizTemplateCfgItemConditions;
import com.xforceplus.ant.coop.rule.center.client.data.cc.request.UpdateBizTemplateCfgItemFieldValue;
import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import com.xforceplus.ant.coop.rule.center.client.data.cc.request.BatchUpdateBizTemplateCfgItem;
import com.xforceplus.ant.coop.rule.center.client.data.cc.response.*;
import io.swagger.annotations.*;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * Describe: 业务模板配置明细 API
 *
 * @Author xiezhongyong
 * @Date 2020-04-02
 */
@Api(value = "biz-template-cfg-items", description = "业务模板配置明细 接口服务")
public interface BizTemplateCfgItemApi {

    @ApiOperation("业务模板明细 列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "templateId", value = "模板ID", dataType = "Long", paramType = "query", required = true)}
    )
    @RequestMapping(value = "/biz-template-cfg-items", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<List<ListBizTemplateCfgItem>> list(@RequestParam(value = "templateId") Long templateId);


    @ApiOperation("获取业务模板配置明细 详情")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "item明细ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/biz-template-cfg-items/{id}", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<GetBizTemplateCfgItem> getTemplateItem(@PathVariable("id") Long id);


    @ApiOperation("批量更新业务模板配置明细")
    @RequestMapping(value = "/biz-template-cfg-items/batch", method = RequestMethod.PUT, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> batchUpdateTemplateItem(@RequestBody @Valid BatchUpdateBizTemplateCfgItem input);

    @ApiOperation("更新业务模板配置明细fieldvalue")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "item明细ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/biz-template-cfg-items/{id}/fieldvalue", method = RequestMethod.PUT, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> updateTemplateItemByFieldValue(@PathVariable("id") Long id, @RequestBody @Valid UpdateBizTemplateCfgItemFieldValue input);

    @ApiOperation("批量更新业务模板配置明细conditions")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "item明细ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/biz-template-cfg-items/{id}/conditions", method = RequestMethod.PUT, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> batchUpdateTemplateItemConditions(@PathVariable("id") Long id, @RequestBody @Valid UpdateBizTemplateCfgItemConditions input);

}
