package com.xforceplus.ant.coop.rule.center.client.api.cc;

import com.xforceplus.ant.coop.rule.center.client.data.cc.request.BatchUpdateFieldSort;
import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import com.xforceplus.ant.coop.rule.center.client.data.cc.request.UpdateBizTemplateSelectItem;
import com.xforceplus.ant.coop.rule.center.client.data.cc.request.UpdateBizTemplateSelectItemField;
import com.xforceplus.ant.coop.rule.center.client.data.cc.response.*;
import io.swagger.annotations.*;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * Describe: 业务模板筛选明细 API
 *
 * @Author xiezhongyong
 * @Date 2020-04-04
 */
@Api(value = "biz-template-select-items", description = "业务模板筛选明细 接口服务")
public interface BizTemplateSelectItemApi {

    @ApiOperation("业务模板筛选明细 列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "templateId", value = "模板ID", dataType = "Long", paramType = "query", required = true)}
    )
    @RequestMapping(value = "/biz-template-select-items", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<List<ListBizTemplateSelectItem>> list(@RequestParam(value = "templateId") Long templateId);

    @ApiOperation("更新业务模板筛选明细")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "item明细ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/biz-template-select-items/{id}", method = RequestMethod.PUT, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> updateTemplateItem(@PathVariable("id") Long id, @RequestBody @Valid UpdateBizTemplateSelectItem input);

    @ApiOperation("批量删除业务模板筛选明细")
    @RequestMapping(value = "/biz-template-select-items/batch", method = RequestMethod.DELETE, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> batchDeleteTemplateItem(@RequestBody @ApiParam(name = "业务模板筛选明细ID列表(格式：['1','2','3'])") List<Long> idList);

    @ApiOperation("获取业务模板筛选明细 详情")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "item明细ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/biz-template-select-items/{id}", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<GetBizTemplateSelectItem> getTemplateItem(@PathVariable("id") Long id);

    @ApiOperation("业务模板添加筛选字段 列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "templateId", value = "模板ID", dataType = "Long", paramType = "query", required = true)}
    )
    @RequestMapping(value = "/biz-template-select-items/fields", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<List<BizTemplateSelectField>> templateFields(@RequestParam(value = "templateId") Long templateId);


    @ApiOperation("更新规则模板字段")
    @RequestMapping(value = "/biz-template-select-items/fields", method = RequestMethod.PUT, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> updateTemplateFields(@RequestBody @Valid UpdateBizTemplateSelectItemField input);

    @ApiOperation("批量更新明细排序")
    @RequestMapping(value = "/biz-template-select-items/fields/sort", method = RequestMethod.PUT, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> batchUpdateFieldShowSort(@RequestBody @Valid BatchUpdateFieldSort input);
}
