package com.xforceplus.ant.coop.rule.center.client.api.cc;

import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import com.xforceplus.ant.coop.rule.center.client.data.cc.request.CreateCoopConfigClass;
import com.xforceplus.ant.coop.rule.center.client.data.cc.request.UpdateCoopConfigClass;
import com.xforceplus.ant.coop.rule.center.client.data.cc.response.GetCoopConfigClass;
import com.xforceplus.ant.coop.rule.center.client.data.cc.response.ListCoopConfigClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * Describe: 协同方分类 API
 *
 * @Author xiezhongyong
 * @Date 2020-03-09
 */
@Api(value = "coop-config-classes", description = "协同方分类 接口服务")
public interface CoopConfigClassApi {

    @ApiOperation("添加分类")
    @RequestMapping(value = "/coop-config-classes",method = RequestMethod.POST, produces = { MediaType.APPLICATION_JSON_VALUE })
    BaseResult<String> create(@RequestBody @Valid CreateCoopConfigClass input);

    @ApiOperation("删除分类")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "ID", required = true, dataType = "Long", paramType = "path") })
    @RequestMapping(value = "/coop-config-classes/{id}",method = RequestMethod.DELETE, produces = { MediaType.APPLICATION_JSON_VALUE })
    BaseResult<String> delete(@PathVariable("id") Long id);

    @ApiOperation("更新分类")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/coop-config-classes/{id}",method = RequestMethod.PUT, produces = { MediaType.APPLICATION_JSON_VALUE })
    BaseResult<String> update(@PathVariable("id") Long id, @RequestBody @Valid UpdateCoopConfigClass input);

    @ApiOperation("获取分类")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "数据id", required = true, dataType = "Long", paramType = "path") })
    @RequestMapping(value = "/coop-config-classes/{id}",method = RequestMethod.GET, produces = { MediaType.APPLICATION_JSON_VALUE })
    BaseResult<GetCoopConfigClass> get(@PathVariable("id") Long id);

    @ApiOperation("分类列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "configObjId", value = "配置方ID(租户ID/企业ID)", dataType = "Long", paramType = "query", required = true)}
    )
    @RequestMapping(value = "/coop-config-classes",method = RequestMethod.GET, produces = { MediaType.APPLICATION_JSON_VALUE })
    BaseResult<List<ListCoopConfigClass>> list(
            @RequestParam(value = "configObjId") Long configObjId
    );
}
