package com.xforceplus.ant.coop.rule.center.client.api.cc;

import com.xforceplus.ant.coop.rule.center.client.data.cc.response.ListEnumConfig;
import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * Describe: 枚举配置
 *
 * @Author xiezhongyong
 * @Date 2020-04-29
 */
@Api(value = "enum-configs", description = "枚举配置 接口服务")
public interface EnumConfigApi {


    @ApiOperation("通过配置类型查询枚举配置列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "configType", value = "配置类型", dataType = "String", paramType = "path")}
    )
    @RequestMapping(value = "/enum-configs/{configType}", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<List<ListEnumConfig>> listByConfigType(@PathVariable(value = "configType") String configType);


    @ApiOperation("拆票备注字段枚举配置列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "configCodes", value = "字段名称列表", dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "configObjId", value = "配置ID", dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "billTypeName", value = "单据类型", dataType = "String", paramType = "query")}
    )
    @RequestMapping(value = "/enum-configs/split-remark", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<List<ListEnumConfig>> splitRemarkList(@RequestParam(value = "configCodes", required = false) List<String> configCodes,
                                          @RequestParam(value = "configObjId", required = false) Long configObjId,
                                          @RequestParam(value = "billTypeName", required = false) String billTypeName);

}
