package com.xforceplus.ant.coop.rule.center.client.api.cc;

import com.xforceplus.ant.coop.rule.center.client.data.cc.request.CheckInvalidCondition;
import com.xforceplus.ant.coop.rule.center.client.data.cc.response.ListEnum;
import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.Valid;
import java.util.List;

/**
 * Describe: 模板通用配置 API
 *
 * @Author xiezhongyong
 * @Date 2020-04-06
 */
@Api(value = "template-common-configs", description = "模板通用配置 接口服务")
public interface TemplateCommonConfigApi {

    @ApiOperation("操作运算符列表")
    @RequestMapping(value = "/template-common-configs/operators",method = RequestMethod.GET, produces = { MediaType.APPLICATION_JSON_VALUE })
    BaseResult<List<ListEnum>> operators();

    @ApiOperation("逻辑运算符列表")
    @RequestMapping(value = "/template-common-configs/logicals",method = RequestMethod.GET, produces = { MediaType.APPLICATION_JSON_VALUE })
    BaseResult<List<ListEnum>> logicals();

    @ApiOperation("条件表达式执行(统一入口)")
    @RequestMapping(value = "/template-common-configs/condition/exp", method = RequestMethod.POST, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> checkConditionExp(@RequestBody @Valid CheckInvalidCondition input);

}
