package com.xforceplus.ant.coop.rule.center.client.api.enterprise;

import com.xforceplus.ant.coop.rule.center.client.data.enterprise.request.*;
import com.xforceplus.ant.coop.rule.center.client.data.enterprise.response.RuleCenterQueryDeviceResponse;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


@Api(value = "taxDevice", description = "the taxDevice API")
public interface ConfigTaxDeviceApi {

    @ApiOperation(value = "添加设备", notes = "", response = Response.class, authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "Enterprise", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/taxDevice/addTaxDevice",
        produces = { "application/json" },
        method = RequestMethod.POST)
     Response addTaxDevice(@ApiParam(value = "添加设备请求对象", required = true) @RequestBody BasicDeviceInfoRequest basicDeviceInfoRequest);


    @ApiOperation(value = "取消订阅", notes = "", response = Response.class, authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "Enterprise", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/taxDevice/cancelSubscribe",
        produces = { "application/json" },
        method = RequestMethod.POST)
     Response cancelSubscribe(@ApiParam(value = "取消订阅", required = true) @RequestBody SubscribeExtractInfo cancelSubscribe);


    @ApiOperation(value = "查询设备", notes = "", response = Response.class, authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "Enterprise", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/taxDevice/getTaxDeviceList",
        produces = { "application/json" },
        method = RequestMethod.POST)
     Response getTaxDeviceList(@ApiParam(value = "查询设备请求对象", required = true) @RequestBody QueryTaxDeviceInfoRequest queryTaxDeviceInfoRequest);


    @ApiOperation(value = "查询订阅信息", notes = "", response = Response.class, authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "Enterprise", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/taxDevice/querySubscribeInfo",
        produces = { "application/json" },
        method = RequestMethod.POST)
     Response querySubscribeInfo(@ApiParam(value = "查询订阅信息", required = true) @RequestBody SubscribeExtractInfo querySubscribeInfo);


    @ApiOperation(value = "税盘抽取订阅信息", notes = "", response = Response.class, authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "Enterprise", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/taxDevice/subscribeExtract",
        produces = { "application/json" },
        method = RequestMethod.POST)
     Response subscribeExtract(@ApiParam(value = "税盘抽取订阅信息", required = true) @RequestBody SubscribeExtractInfo subscribeExtract);


    @ApiOperation(value = "更新设备信息", notes = "", response = Response.class, authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "Enterprise", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/taxDevice/updateTaxDevice",
        produces = { "application/json" },
        method = RequestMethod.POST)
     Response updateTaxDevice(@ApiParam(value = "更新设备请求对象", required = true) @RequestBody BasicDeviceInfoRequest basicDeviceInfoRequest);


    @ApiOperation(value = "更新设备状态", notes = "", response = Response.class, authorizations = {
        @Authorization(value = "X-Access-Token")
    }, tags={ "Enterprise", })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/taxDevice/updateTaxDeviceStatus",
        produces = { "application/json" },
        method = RequestMethod.POST)
     Response updateTaxDeviceStatus(@ApiParam(value = "更新税控设备请求对象", required = true) @RequestBody UpdateTaxDeviceStatusRequest updateTaxDeviceStatusRequest);

    @ApiOperation(value = "查询设备列表", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token")
    }, tags={ "Enterprise", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = Response.class) })
    @RequestMapping(value = "/taxDevice/deviceQueryPost",
            produces = { "application/json" },
            method = RequestMethod.POST)
    RuleCenterQueryDeviceResponse deviceQueryPost(@ApiParam(value = "查询设备请求对象", required = true) @RequestBody RuleCenterQueryDeviceRequest request);

}
