package com.xforceplus.ant.coop.rule.center.client.data.canary;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;

/**
 * Describe: 修改灰度路由配置
 *
 * @Author xiezhongyong
 * @Date 2021-03-15
 */
@Data
public class UpdateCanaryRouteConfig {

    @Length(message = "灰度路由名称 最多输入100字符", max = 100)
    @ApiModelProperty("灰度路由名称")
    private String canaryRouteName;

    @Length(message = "灰度路由标识 最多输入50字符", max = 50)
    @ApiModelProperty("灰度路由标识")
    private String canaryRouteKey;

    @Length(message = "备注最多输入100字符", max = 100)
    @ApiModelProperty("备注")
    private String remark;

    @Pattern(regexp = "^0$|^1$", message = "状态 不合法")
    @ApiModelProperty("状态 0=启用；1=停用")
    private String status = "0";
}
