package com.xforceplus.ant.coop.rule.center.client.data.cc.bean.fieldlimit;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;
import java.util.List;

/**
 * Describe: enumValue-枚举值
 *
 * @Author xiezhongyong
 * @Date 2020-03-27
 */
@Data
public class EnumValueLimit extends FieldLimit {
    @Valid
    @ApiModelProperty("枚举值列表")
    private List<EnumValue> enumValues;
    @Pattern(regexp = "^0$|^1$", message = "失效状态 不合法")
    @ApiModelProperty("失效状态：0:启用;1:停用")
    private String invalidStatus = "1";
    @ApiModelProperty("失效条件")
    private String invalidCondition;

    @Data
    public static class EnumValue {
        @NotEmpty(message = "枚举code码 不能为空")
        @ApiModelProperty("枚举code码")
        private String code;
        @NotEmpty(message = "枚举显示文本 不能为空")
        @ApiModelProperty("枚举显示文本")
        private String text;
    }
}
