package com.xforceplus.ant.coop.rule.center.client.data.cc.bean.fieldlimit;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Pattern;

/**
 * Describe: rangeValue-区间值
 *
 * @Author xiezhongyong
 * @Date 2020-03-27
 */
@Data
public class RangeValueLimit extends FieldLimit {
    @ApiModelProperty("最小区间值")
    private String minValue;
    @ApiModelProperty("最大区间值")
    private String maxValue;
    @Pattern(regexp = "^0$|^1$", message = "失效状态 不合法")
    @ApiModelProperty("失效状态：0:启用;1:停用")
    private String invalidStatus = "1";
    @ApiModelProperty("失效条件")
    private String invalidCondition;

}
