package com.xforceplus.ant.coop.rule.center.client.data.cc.bean.fieldlimit;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Pattern;

/**
 * Describe: tolRange-容差范围
 *
 * @Author xiezhongyong
 * @Date 2020-04-02
 */
@Data
public class TolRangeLimit extends FieldLimit {
    @ApiModelProperty("最小区间值")
    private String minValue;
    @ApiModelProperty("最大区间值")
    private String maxValue;
    @ApiModelProperty("单位 0-固定金额（默认） 1-百分比")
    @Pattern(regexp = "^0$|^1$", message = "单位 不合法")
    private String unit = "0";


}
