package com.xforceplus.ant.coop.rule.center.client.data.cc.bean.limiters;


import java.util.Arrays;

/**
 * Describe: 字段类型
 * 字段类型 a-多文本 s-文本 n-数值 d-日期  t-时间  l-联想
 * @Author xiezhongyong
 * @Date 2020-02-12
 */
public enum FieldTypeEnum {

    A ("a", "等于"),
    S ("s", "不等于"),
    N ("n", "大于"),
    D ("d", "小于"),
    T ("t", "大于等于"),
    L ("l", "小于等于")
    ;
    private final String code;
    private final String message;

    FieldTypeEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String code() {
        return code;
    }

    public String message() {
        return message;
    }

    public static FieldTypeEnum fromValue(String code) {
        return Arrays.stream(FieldTypeEnum.values())
                .filter(s -> s.code.equals(code))
                .findAny()
                .orElse(null);
    }
}
