package com.xforceplus.ant.coop.rule.center.client.data.cc.bean.limiters;


import java.util.Arrays;

/**
 * Describe: 逻辑运算符
 * @Author xiezhongyong
 * @Date 2020-02-12
 */
public enum LogicalEnum {

    AND ("AND", "并且", " && "),
    OR ("OR", "或", " || ")
    ;

    private final String code;
    private final String message;
    private final String exp;

    LogicalEnum(String code, String message, String exp) {
        this.code = code;
        this.message = message;
        this.exp = exp;
    }

    public String code() {
        return code;
    }

    public String message() {
        return message;
    }
    public String exp() {
        return exp;
    }

    public static LogicalEnum fromValue(String code) {
        return Arrays.stream(LogicalEnum.values())
                .filter(s -> s.code.equals(code))
                .findAny()
                .orElse(null);
    }
}
