package com.xforceplus.ant.coop.rule.center.client.data.cc.bean.limiters;


import java.util.Arrays;

/**
 * Describe: 限定条件 操作符
 * @Author xiezhongyong
 * @Date 2020-02-12
 */
public enum OperatorEnum {
    EQ ("EQ", "等于"),
    NE ("NE", "不等于"),
    GT ("GT", "大于"),
    LT ("LT", "小于"),
    GE ("GE", "大于等于"),
    LE ("LE", "小于等于"),
    IS_EMPTY ("IS_EMPTY", "为空/为NULL"),
    NOT_EMPTY ("NOT_EMPTY", "不为空/不为NULL"),
    LIKE("LIKE", "包含")
    ;

    private final String code;
    private final String message;

    OperatorEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String code() {
        return code;
    }

    public String message() {
        return message;
    }

    public static OperatorEnum fromValue(String code) {
        return Arrays.stream(OperatorEnum.values())
                .filter(s -> s.code.equals(code))
                .findAny()
                .orElse(null);
    }
}
