package com.xforceplus.ant.coop.rule.center.client.data.cc.enums;


import java.util.Arrays;

/**
 * Describe: 业务模板 基础配置 状态列表
 * @Author xiezhongyong
 * @Date 2020-06-11
 */
public enum BizCfgItemStatusEnum {

    ENABLED(0, "启用"),
    DISABLED (1, "停用");

    private final Integer code;
    private final String message;

    BizCfgItemStatusEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    public Integer code() {
        return code;
    }

    public String message() {
        return message;
    }

    public static BizCfgItemStatusEnum fromValue(String code) {
        return Arrays.stream(BizCfgItemStatusEnum.values())
                .filter(s -> s.code.equals(code))
                .findAny()
                .orElse(null);
    }
}
