package com.xforceplus.ant.coop.rule.center.client.data.cc.enums;

import java.util.Arrays;

/**
 * Describe: SplitRemarkEnum ：拆票规则备注字段
 *
 * @Author xiezhongyong
 * @Date 2020-10-27
 */
public enum EnumConfigType {

    Split_Remark_Enum("SplitRemarkEnum", "拆票规则备注字段");

    private final String code;
    private final String message;

    EnumConfigType(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String code() {
        return code;
    }

    public String message() {
        return message;
    }

    public static EnumConfigType fromValue(int code) {
        return Arrays.stream(EnumConfigType.values())
                .filter(s -> s.code.equals(code))
                .findAny()
                .orElse(null);
    }
}
