package com.xforceplus.ant.coop.rule.center.client.data.cc.enums;

import java.util.Arrays;

/**
 * Describe: 模板配置modelType枚举
 * @Author xiezhongyong
 * @Date 2020-05-22
 */
public enum TcModelTypeEnum {

    /** 标准结算单*/
    BILL(1001001, "结算单-数据模板", "bill"),
    BILL_MODIFY(2, "结算单修改控制", "billUpdate"),
    BILL_SHOW(3, "结算单列显示控制", "billListShow"),
    BILL_ITEM_MODIFY(4, "结算单明细修改控制", "billItemUpdate"),
    BILL_CONFIRM_VALID(220, "结算单确认校验控制", "billConfirmValid"),
    BILL_ITEM_SHOW(221, "结算单明细列显示控制", "billItemListShow"),
    BILL_DETAIL_SHOW(222, "结算单详情显示控制", "billDetailsShow"),
    BILL_QUERY(223, "结算单筛选控制", "billQuery"),
    BILL_ITEM_FIELD_MAPPING(2001014, "结算单明细字段映射控制", "billItemFieldMapping"),
    BILL_EXPORT(2001015, "结算单导出控制", "billExport"),
    BILL_ITEM_EXPORT(2001016, "结算单明细导出控制", "billItemExport"),
    BILL_ITEM_CHILD_SPLIT(2001017, "结算单明细子单拆分控制", "billItemChildSplit"),
    BILL_IMPORT(2001018, "结算单主表及明细导入控制", "billImport"),
    BILL_DEFAULT_SELECT(2001019, "结算单默认筛选项控制", "billDefaultSelect"),
    /** 结算单基础配置*/
    BILL_BASIC_CONFIG(3001001, "结算单基础-配置模板", "billBasicConfig"),
    BILL_ITEM_SPLIT(3001003, "结算单明细拆分-配置模板", "billItemSplitCfg"),

    BILL_BASIC_OPS_CONFIG(3001004, "结算单基础-运维配置", "billBasicOpsConfig"),


    BACK_FILL_TOLERANCE(230, "结算单发票容差-配置模板", "backfillTolCfg"),



    /** 华润--按明细类型修改控制*/
    HR_SINGLE_101(101, "华润-单条修改-税编可以为空", "billItemModifyControlFileds"),
    HR_SINGLE_102(102, "华润-单条修改-免税", "billItemModifyControlFileds"),
    HR_SINGLE_103(103, "华润-单条修改-税编可以为空+免税", "billItemModifyControlFileds"),
    HR_SINGLE_112(112, "华润-单条修改-不带任何标识的标准结算单", "billItemModifyControlFileds"),
    HR_MANY_121(121, "华润-多条修改", "billItemModifyControlFileds"),

    /** 拆票规则*/
    INVOICE_SPLIT_DATA(1002001, "拆票规则-数据模板", "invoiceSplit"),
    INVOICE_SPLIT(1, "拆票规则控制", "invoiceSplitConfig"),
    INVOICE_SPLIT_CE(11, "拆票规则控制-电票", "invoiceSplitConfig-ce"),
    INVOICE_SPLIT_C(12, "拆票规则控制-普票", "invoiceSplitConfig-c"),
    INVOICE_SPLIT_S(13, "拆票规则控制-专票", "invoiceSplitConfig-s"),
    INVOICE_SPLIT_SE(131, "拆票规则控制-电专票", "invoiceSplitConfig-se"),
    INVOICE_SPLIT_V(14, "拆票规则控制-机动车票", "invoiceSplitConfig-v"),
    INVOICE_SPLIT_JU(15, "拆票规则控制-卷票", "invoiceSplitConfig-ju"),
    INVOICE_SPLIT_T(16, "拆票规则控制-通打票", "invoiceSplitConfig-t"),

    /** 商品管理*/
    GOOD_MODIFY_DATA(1003001, "商品信息-数据模板", "goodInfo"),
    GOOD_MODIFY(211, "商品修改控制", "goodInfoUpdate"),
    /** 票面规则*/
    INVOICE_INFO_DATA(1004001, "票面信息-数据模板", "invoiceCoverInfo"),
    INVOICE_INFO(6, "票面信息修改控制", "invoiceCoverInfoUpdate"),



    /** 结算单金额调整明细*/
    BILL_AMOUNT_ADJUSTITEM(1005001, "结算单金额调整明细-数据模板", "billAmountAdjustItem"),
    BILL_AMOUNT_ADJUST_ITEM_MAPPING(2005001, "结算单金额调整明细映射控制", "billAmountAdjustItemMapping"),
    BILL_AMOUNT_ADJUST_ITEM_EXPORT(2005002, "结算单金额调整明细导出控制", "billAmountAdjustItemExport"),

    /** 结算单收货*/
    BILL_RECEIVING(1006001, "结算单收货-数据模板", "billReceiving"),
    BILL_RECEIVING_MAPPING(2006001, "结算单收货映射控制", "billReceivingMapping"),
    BILL_RECEIVING_EXPORT(2006002, "结算单收货导出控制", "billReceivingExport"),

    /** 结算单-损耗跟踪单*/
    BILL_LOSS_TRACE(1007001, "结算单-损耗跟踪单-数据模板", "billLossTrace"),
    BILL_LOSS_TRACE_MAPPING(2007001, "结算单-损耗跟踪单映射控制", "billLossTraceMapping"),
    BILL_LOSS_TRACE_EXPORT(2007002, "结算单-损耗跟踪单导出控制", "billLossTraceExport"),

    /** 结算单发票信息*/
    BILL_INVOICE_INFO(1008001, "结算单发票信息-数据模板", "billInvoiceInfo"),
    BILL_INVOICE_FIELD_MAPPING(2008001, "结算单发票信息字段映射控制", "billInvoiceFieldMapping"),

    /** 发票控制*/
    INVOICE_MAINI_NFO(1009001, "发票信息-数据模板", "invoiceMainInfo"),
    INVOICE_SHOW(7, "发票列显示控制", "invoiceShowControlFields"),
    INVOICE_BACKFILL(2009002, "发票回填控制", "invoiceBackfill"),
    INVOICE_CONFIG(3003001, "发票基础-配置模板", "invoiceConfig"),
    SELLER_INVOICE_CONFIG(3003002, "发票基础-配置(供应商)", "sellerInvoiceConfig"),
    INVOICE_BACKFILL_CONFIG(3003003, "发票回填-配置模板", "invoiceBackfillConfig"),

    /** 通用配置*/
    COMMON_BASIC_CONFIG(3004001,"通用配置信息基础配置-配置模板","commonBasicConfig"),


    /** 结算规则*/
    SR_BASIC_CONFIG(3005001,"结算规则基础配置","srBasicConfig"),


    /** 百安居定制*/
    SELLER_BAJ_INFO(1010001,"百安居供应商定制","sellerBajInfo"),
    SELLER_BAJ_CONFIG(2010001,"百安居供应商定制配置","sellerBajConfig")
    ;

    private final Integer code;
    private final String msg;
    private final String templateCode;

    TcModelTypeEnum(Integer code, String msg, String templateCode) {
        this.code = code;
        this.msg = msg;
        this.templateCode = templateCode;
    }

    public String templateCode() {
        return templateCode;
    }

    public Integer code(){
        return code;
    }

    public String msg(){
        return msg;
    }

    public static TcModelTypeEnum fromValue(Integer code) {
        return Arrays.stream(TcModelTypeEnum.values()).filter(configModelTypeEnum -> configModelTypeEnum.code().equals(code)).findFirst().orElseGet(() -> null);
    }
}
