package com.xforceplus.ant.coop.rule.center.client.data.cc.enums.bizcfg;

import java.util.Arrays;

/**
 * Describe: 发票基础配置
 * 3003001	业务模板	invoice-config	发票基础-配置模板	发票	3003001
 *
 * @Author xiezhongyong
 * @Date 2020-06-11
 */
public enum InvoiceBasicConfigEnum implements IBasicConfigEnum {


    NEW_BILL("coopNewBillOnRedDeposeFlag", "红冲作废重生结算单"),
    ASSOCIATE_CANCEL_AFTER_AUTH("coopAssociateCancelAfterAuth", "认证后可取消关联"),
    ASSOCIATE_CANCEL_AFTER_SCAN("coopAssociateCancelAfterScan", "扫描后可取消关联"),
    ASSOCIATE_CANCEL_AFTER_RED("coopAssociateCancelAfterRed", "红冲后可取消关联"),
    ASSOCIATE_CANCEL_AFTER_ABANDON("coopAssociateCancelAfterAbandon", "作废后可取消关联"),


    // 以下是新增配置
    COOP_INVOICE_LOCK_NOT_INVALID("coopInvoiceLockNotInvalid","发票锁定后不可作废"),
    COOP_INVOICE_LOCK_NOT_RED("coopInvoiceLockNotRed","发票锁定后不可红冲"),
    COOP_INVOICE_SCAN_NOT_INVALID("coopInvoiceScanNotInvalid","发票已扫描不可作废"),
    COOP_INVOICE_SCAN_NOT_RED("coopInvoiceScanNotRed","发票已扫描不可红冲"),
    COOP_INVOICE_AUTH_NOT_INVALID("coopInvoiceAuthNotInvalid","发票已认证不可作废"),
    COOP_INVOICE_AUTH_NOT_RED("coopInvoiceAuthNotRed","发票已认证不可红冲"),
//    COOP_INVOICE_OPENER_LOCK("coopInvoiceOpenerLock","发票开具后是否锁定"),
    COOP_INVOICE_RED_TYPE_MUTUAL("coopInvoiceRedTypeMutual","红冲类型支持纸电互冲"),
    COOP_SPLIT_RULE_ADAPTER_BILL_TYPE("coopSplitRuleAdapterBillType","拆票规则适配单据类型"),
    COOP_PRE_INVOICE_BACK_FILL("coopPreInvoiceBackFill","预制发票回填明细控制(开启:预制发票;关闭:查验)"),
    COOP_INVOICE_REMARK_FIELD_CHECK("coopInvoiceRemarkFieldCheck","发票备注字段检验(开启:检验;关闭:不校验)"),
    ALL("ALL","全部配置项"),
    UNDEFINED("","未定义的配置项"),
    ;
    private Integer modelType = 3003001;
    private Long commonTemplateId = 3003001L;



    @Override
    public Integer modelType() {
        return modelType;
    }

    @Override
    public Long commonTemplateId() {
        return commonTemplateId;
    }

    private String code;
    private String message;


    InvoiceBasicConfigEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    @Override
    public String code() {
        return this.code;
    }

    @Override
    public void code(String code) {
        this.code = code;
    }

    @Override
    public String message() {
        return this.message;
    }

    public static InvoiceBasicConfigEnum fromValue(String code) {
        InvoiceBasicConfigEnum anEnum = Arrays.stream(InvoiceBasicConfigEnum.values())
                .filter(s -> s.code.equals(code))
                .findAny()
                .orElse(null);
        if (null == anEnum) {
            UNDEFINED.code(code);
            return UNDEFINED;
        }
        return anEnum;
    }
}
