package com.xforceplus.ant.coop.rule.center.client.data.cc.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;

/**
 * Describe: 创建 协同配置
 *
 * @Author xiezhongyong
 * @Date 2020-03-09
 */
@Data
public class CreateCoopConfig {

    @NotEmpty(message = "配置方ID 不能为空")
    @ApiModelProperty("配置方ID(租户ID、企业ID 等)")
    private String configObjId;

    @NotEmpty(message = "配置方名称 不能为空")
    @ApiModelProperty("配置方名称")
    private String configObjName;

    @NotEmpty(message = "配置方code 不能为空")
    @ApiModelProperty("配置方code")
    private String configObjCode;

    @ApiModelProperty("配置类型 0-购方配置(默认) 1-供应商配置 2-渠道商配置")
    @Pattern(regexp = "^0$|^1$|^2$", message = "配置类型 不合法")
    private String configType = "0";

    @NotEmpty(message = "分类ID 不能为空")
    @ApiModelProperty("分类ID")
    private String coopConfigClassId;
}
