package com.xforceplus.ant.coop.rule.center.client.data.cc.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

/**
 * Describe: 规则,业务,检验模板关联对象 修改
 *
 * @Author xiezhongyong
 * @Date 2020-07-06
 */
@Data
public class UpdateTemplateBindObj {
    @NotNull(message = "关联对象ID 不能为空")
    @ApiModelProperty("关联对象ID")
    private Long bindObjId;
    @ApiModelProperty("关联对象code")
    private String bindObjCode;
    @ApiModelProperty("关联对象名称")
    private String bindObjName;
    @Pattern(regexp =  "^1$|^2$", message = "关联对象类型 不合法")
    @ApiModelProperty("关联对象类型 1-租户(默认) 2-企业")
    private Integer bindObjType = 1;
}
