package com.xforceplus.ant.coop.rule.center.client.data.cc.response;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * Describe: 业务模板字段 列表
 *
 * @Author xiezhongyong
 * @Date 2020-03-17
 */
@Data
public class BizTemplateSelectField {
    @ApiModelProperty("下标/排序")
    private Integer index;
    @ApiModelProperty("字段分组名称")
    private String title;
    @ApiModelProperty("字段列表")
    private List<Field> fields = new ArrayList<>();

    @Data
    public static class Field {
        @ApiModelProperty("数据ID")
        private String id;
        @ApiModelProperty("字段名")
        private String fieldName;
        @ApiModelProperty("字段中文名称")
        private String fieldDisplayName;
        @ApiModelProperty("字段类型")
        private String fieldType;
        @ApiModelProperty("筛选字段名")
        private String selectFieldName;
        @ApiModelProperty("筛选字段中文名称")
        private String selectFieldDisplayName;
        @ApiModelProperty("扩展字段标识 0-固定字段 1-扩展字段")
        private Integer extFalg;
        @ApiModelProperty("编辑标记 0-可以编辑和删除 1-可编辑,不能删除 2-不可编辑,可以删除 3-不可编辑和删除")
        private Integer editFlag;
        @ApiModelProperty("字段删除标记  0-正常  1-删除")
        private Integer deleteFlag;

    }
}
