package com.xforceplus.ant.coop.rule.center.client.data.cc.response;

import com.xforceplus.ant.coop.rule.center.client.data.cc.bean.FieldEnumValue;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * Describe: 数据模板详情
 *
 * @Author xiezhongyong
 * @Date 2020-03-25
 */
@Data
public class DataTemplateDetail {
    @ApiModelProperty("数据ID")
    private String id;
    @ApiModelProperty("模板代码")
    private String templateCode;
    @ApiModelProperty("模型类型")
    private Integer modelType;
    @ApiModelProperty("协同配置ID")
    private String coopConfigId;
    @ApiModelProperty("模板分类ID")
    private String templateClassId;
    @ApiModelProperty("通用模板标记 0-否(默认) 1-是")
    private Integer commonFlag;
    @ApiModelProperty("模板范围 0-购方配置(默认) 1-供应商配置 2-渠道商配置 10-通用")
    private Integer templateScope;
    @ApiModelProperty("配置方ID")
    private Long configObjId;
    @ApiModelProperty("行业代码  global-全局(默认值) coop-协同产品线 retail-零售 estate-地产")
    private String industryCode;
    @ApiModelProperty("单据类型ID")
    private String billTypeId;
    @ApiModelProperty("模板名称")
    private String templateName;
    @ApiModelProperty("版本号")
    private String version;
    @ApiModelProperty("模板配置明细")
    private List<ConfigItem> items = new ArrayList<>();


    @Data
    public static class ConfigItem {
        @ApiModelProperty("数据ID")
        private String id;
        @ApiModelProperty("字段名")
        private String fieldName;
        @ApiModelProperty("字段中文名称")
        private String fieldDisplayName;
        @ApiModelProperty("字段类型 a-多文本 s-文本 n-数值 d-日期  t-时间  l-联想")
        private String fieldType;
        @ApiModelProperty("字段格式化")
        private String fieldFormat;
        @ApiModelProperty("字段长度")
        private Integer fieldLength;
        @ApiModelProperty("字段查询方式 eq-精确  like-模糊 rang-范围 checkbox-枚举复选 radio-枚举单选")
        private String fieldQueryType;
        @ApiModelProperty("必填标志 0-非必填(默认) 1-必填")
        private Integer fieldRequired;
        @ApiModelProperty("扩展字段标识 0-固定字段 1-扩展字段")
        private Integer extFalg;
        @ApiModelProperty("排序")
        private Integer sort;
        @ApiModelProperty("枚举值对象列表")
        private List<FieldEnumValue> fieldEnumValues;

        @ApiModelProperty("字段分组")
        private String fieldGroup;
        @ApiModelProperty("字段分组下标")
        private Integer fieldGroupIndex;
        @ApiModelProperty("字段分组名称")
        private String fieldGroupName;
    }
}
