package com.xforceplus.ant.coop.rule.center.client.data.cc.response;

import com.xforceplus.ant.coop.rule.center.client.data.cc.bean.limiters.Conditions;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * Describe: 规则模板 详情
 *
 * @Author xiezhongyong
 * @Date 2020-03-26
 */
@Data
public class GetBizTemplate {
    @ApiModelProperty("数据ID")
    private String id;
    @ApiModelProperty("模板代码")
    private String templateCode;
    @ApiModelProperty("协同配置ID")
    private String coopConfigId;
    @ApiModelProperty("模板分类ID")
    private String templateClassId;
    @ApiModelProperty("父模板ID(顶级模板父ID为0)")
    private String parentTemplateId;
    @ApiModelProperty("数据模板ID")
    private String dataTemplateId;
    @ApiModelProperty("通用模板标记 0-否(默认) 1-是")
    private Integer commonFlag;
    @ApiModelProperty("模板范围 0-购方配置(默认) 1-供应商配置 2-渠道商配置 10-通用")
    private Integer templateScope;
    @ApiModelProperty("配置方ID")
    private Long configObjId;
    @ApiModelProperty("关联对象ID")
    private String bindObjId;
    @ApiModelProperty("关联对象code")
    private String bindObjCode;
    @ApiModelProperty("关联对象名称")
    private String bindObjName;
    @ApiModelProperty("关联对象类型 1-租户(默认) 2-企业")
    private String bindObjType;
    @ApiModelProperty("行业代码  global-全局(默认值) coop-协同产品线 retail-零售 estate-地产")
    private String industryCode;
    @ApiModelProperty("继承标识 0-不允许继承 1-允许单继承(默认) 2-允许多继承")
    private Integer extendsFlag;
    @ApiModelProperty("公开标记 0-公开 1-不公开")
    private Integer openFlag;
    @ApiModelProperty("单据类型ID")
    private String billTypeId;
    @ApiModelProperty("模板名称")
    private String templateName;
    @ApiModelProperty("模板类型 0-规则模板 1-筛选模板")
    private Integer templateType;
    @ApiModelProperty("适用范围 0-通用 1-限定条件")
    private Integer applyRange;
    @ApiModelProperty("版本号")
    private String version;
    @ApiModelProperty("状态(停用模板无法被继承) 0-启用(默认) 1-停用")
    private Integer status;
    @ApiModelProperty("编辑标记 0-可以编辑和删除 1-可编辑,不能删除 2-不可编辑,可以删除 3-不可编辑和删除")
    private Integer editFlag;
    @ApiModelProperty("创建时间")
    private String createTime;
    @ApiModelProperty("创建人")
    private String createUser;
    @ApiModelProperty("创建人姓名")
    private String createUserName;

    @ApiModelProperty("限定条件表达式")
    private String limitersExp;
    @ApiModelProperty("限定条件列表")
    private Conditions limiters;

    @ApiModelProperty("业务单类型名称")
    private String billTypeName;
}
