package com.xforceplus.ant.coop.rule.center.client.data.cc.response;

import com.xforceplus.ant.coop.rule.center.client.data.cc.bean.fieldlimit.FieldLimit;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bean.limiters.Conditions;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.util.List;

/**
 * Describe: 购方业务模板配置明细 详情
 *
 * @Author xiezhongyong
 * @Date 2020-04-01
 */
@Data
public class GetBizTemplateCfgItem {

    @ApiModelProperty("数据ID")
    private String id;
    @ApiModelProperty("模板ID")
    private String templateId;
    @ApiModelProperty("元数据明细ID")
    private String metadataItemId;
    @ApiModelProperty("字段优先级 0-通用模板 1-购方模板")
    private Integer level;
    @ApiModelProperty("父明细ID(通用明细ID)")
    private String parentItemId;
    @ApiModelProperty("版本号")
    private String version;
    @ApiModelProperty("字段名")
    private String fieldName;
    @ApiModelProperty("字段中文名称")
    private String fieldDisplayName;
    @ApiModelProperty("字段值 0-启用 1-停用")
    private Integer fieldValue;
    @ApiModelProperty("条件开关 0支持配置 1-不支持配置")
    private Integer conditionActive;
    @ApiModelProperty("条件类型 0-生效条件 1-失效条件")
    private Integer conditionType;
    @ApiModelProperty("条件状态 0-启用 1-停用")
    private Integer conditionStatus;
    @ApiModelProperty("条件MD5")
    private String conditionMd5;
    @ApiModelProperty("字段限制类型(表示当前字段可修改的字段限制)")
    private String fieldLimitType;
    @ApiModelProperty("字段分组")
    private String fieldGroup;
    @ApiModelProperty("字段分组下标")
    private Integer fieldGroupIndex;
    @ApiModelProperty("字段分组名称")
    private String fieldGroupName;
    @ApiModelProperty("虚拟标记 0-非虚拟字段 1-虚拟字段")
    private Integer virtualFlag;
    @ApiModelProperty("扩展字段标识 0-固定字段 1-扩展字段")
    private Integer extFalg;
    @ApiModelProperty("编辑标记 0-可以编辑和删除 1-可编辑,不能删除 2-不可编辑,可以删除 3-不可编辑和删除")
    private Integer editFlag;
    @ApiModelProperty("字段删除标记  0-正常  1-删除")
    private Integer deleteFlag;
    @ApiModelProperty("排序")
    private Integer sort;
    @ApiModelProperty("创建时间")
    private String createTime;
    @ApiModelProperty("创建人")
    private String createUser;
    @ApiModelProperty("创建人姓名")
    private String createUserName;
    @ApiModelProperty("更新时间")
    private String updateTime;
    @ApiModelProperty("更新人")
    private String updateUser;
    @ApiModelProperty("更新人姓名")
    private String updateUserName;
    @ApiModelProperty("条件表达式")
    private String conditionExp;

    @ApiModelProperty("字段限制对象列表")
    private List<FieldLimit> fieldLimits;
    @ApiModelProperty("条件列表")
    private Conditions conditions;
}
