package com.xforceplus.ant.coop.rule.center.client.data.cc.response;

import com.xforceplus.ant.coop.rule.center.client.data.cc.bean.fieldlimit.FieldLimit;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * Describe: 购方业务模板筛选明细 详情
 *
 * @Author xiezhongyong
 * @Date 2020-04-03
 */
@Data
public class GetBizTemplateSelectItem {

    @ApiModelProperty("数据ID")
    private String id;
    @ApiModelProperty("模板ID")
    private String templateId;
    @ApiModelProperty("元数据明细ID")
    private String metadataItemId;
    @ApiModelProperty("字段优先级 0-通用模板 1-购方模板")
    private Integer level;
    @ApiModelProperty("父明细ID(通用明细ID)")
    private String parentItemId;
    @ApiModelProperty("数据模板明细ID")
    private String dataItemId;
    @ApiModelProperty("版本号")
    private String version;
    @ApiModelProperty("字段名")
    private String fieldName;
    @ApiModelProperty("字段中文名称")
    private String fieldDisplayName;
    @ApiModelProperty("字段类型")
    private String fieldType;
    @ApiModelProperty("筛选字段名")
    private String selectFieldName;
    @ApiModelProperty("筛选字段中文名称")
    private String selectFieldDisplayName;
    @ApiModelProperty("筛选字段类型")
    private String selectFieldType;
    @ApiModelProperty("字段显示顺序")
    private Integer fieldShowSort;
    @ApiModelProperty("字段限制类型(表示当前字段可修改的字段限制)")
    private String fieldLimitType;
    @ApiModelProperty("字段分组")
    private String fieldGroup;
    @ApiModelProperty("字段分组下标")
    private Integer fieldGroupIndex;
    @ApiModelProperty("字段分组名称")
    private String fieldGroupName;
    @ApiModelProperty("虚拟标记 0-非虚拟字段 1-虚拟字段")
    private Integer virtualFlag;
    @ApiModelProperty("扩展字段标识 0-固定字段 1-扩展字段")
    private Integer extFalg;
    @ApiModelProperty("编辑标记 0-可以编辑和删除 1-可编辑,不能删除 2-不可编辑,可以删除 3-不可编辑和删除")
    private Integer editFlag;
    @ApiModelProperty("字段删除标记  0-正常  1-删除")
    private Integer deleteFlag;
    @ApiModelProperty("排序")
    private Integer sort;
    @ApiModelProperty("创建时间")
    private String createTime;
    @ApiModelProperty("创建人")
    private String createUser;
    @ApiModelProperty("创建人姓名")
    private String createUserName;
    @ApiModelProperty("更新时间")
    private String updateTime;
    @ApiModelProperty("更新人")
    private String updateUser;
    @ApiModelProperty("更新人姓名")
    private String updateUserName;


    @ApiModelProperty("字段限制对象列表")
    private List<FieldLimit> fieldLimits;
}
