package com.xforceplus.ant.coop.rule.center.client.data.cc.response;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * Describe: 购方数据模板 详情
 *
 * @Author xiezhongyong
 * @Date 2020-03-25
 */
@Data
public class GetDataTemplate {
    @ApiModelProperty("数据ID")
    private String id;
    @ApiModelProperty("模板代码")
    private String templateCode;
    @ApiModelProperty("协同配置ID")
    private String coopConfigId;
    @ApiModelProperty("模板分类ID")
    private String templateClassId;
    @ApiModelProperty("父模板ID(顶级模板父ID为0)")
    private String parentTemplateId;
    @ApiModelProperty("通用模板标记 0-否(默认) 1-是")
    private Integer commonFlag;
    @ApiModelProperty("模板范围 0-购方配置(默认) 1-供应商配置 2-渠道商配置 10-通用")
    private Integer templateScope;
    @ApiModelProperty("配置方ID")
    private Long configObjId;
    @ApiModelProperty("行业代码  global-全局(默认值) coop-协同产品线 retail-零售 estate-地产")
    private String industryCode;
    @ApiModelProperty("继承标识 0-不允许继承 1-允许单继承(默认) 2-允许多继承")
    private Integer extendsFlag;
    @ApiModelProperty("公开标记 0-公开 1-不公开")
    private Integer openFlag;
    @ApiModelProperty("单据类型ID")
    private String billTypeId;
    @ApiModelProperty("模板名称")
    private String templateName;
    @ApiModelProperty("版本号")
    private String version;
    @ApiModelProperty("状态(停用模板无法被继承) 0-启用(默认) 1-停用")
    private Integer status;
    @ApiModelProperty("编辑标记 0-可以编辑和删除 1-可编辑,不能删除 2-不可编辑,可以删除 3-不可编辑和删除")
    private Integer editFlag;
    @ApiModelProperty("创建时间")
    private String createTime;
    @ApiModelProperty("创建人")
    private String createUser;
    @ApiModelProperty("创建人姓名")
    private String createUserName;
    @ApiModelProperty("更新时间")
    private String updateTime;
    @ApiModelProperty("更新人")
    private String updateUser;
    @ApiModelProperty("更新人姓名")
    private String updateUserName;

    @ApiModelProperty("业务单类型名称")
    private String billTypeName;
}
