package com.xforceplus.ant.coop.rule.center.client.data.cc.response;

import com.xforceplus.ant.coop.rule.center.client.data.cc.bean.fieldlimit.FieldLimit;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bean.limiters.Conditions;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * Describe: 业务模板 配置明细 列表
 *
 * @Author xiezhongyong
 * @Date 2020-04-01
 */
@Data
public class ListBizTemplateCfgItem {

    @ApiModelProperty("数据ID")
    private String id;
    @ApiModelProperty("模板ID")
    private String templateId;
    @ApiModelProperty("字段名")
    private String fieldName;
    @ApiModelProperty("字段中文名称")
    private String fieldDisplayName;
    @ApiModelProperty("字段值 0-启用 1-停用")
    private Integer fieldValue;
    @ApiModelProperty("条件开关 0支持配置 1-不支持配置")
    private Integer conditionActive;
    @ApiModelProperty("条件类型 0-生效条件 1-失效条件")
    private Integer conditionType;
    @ApiModelProperty("条件状态 0-启用 1-停用")
    private Integer conditionStatus;
    @ApiModelProperty("条件MD5")
    private String conditionMd5;
    @ApiModelProperty("字段限制类型(表示当前字段可修改的字段限制)")
    private String fieldLimitType;
    @ApiModelProperty("扩展字段标识 0-固定字段 1-扩展字段")
    private Integer extFalg;
    @ApiModelProperty("编辑标记 0-可以编辑和删除 1-可编辑,不能删除 2-不可编辑,可以删除 3-不可编辑和删除")
    private Integer editFlag;
    @ApiModelProperty("排序")
    private Integer sort;

    @ApiModelProperty("条件表达式")
    private String conditionExp;

    @ApiModelProperty("字段限制对象列表")
    private List<FieldLimit> fieldLimits;
    @ApiModelProperty("条件列表")
    private Conditions conditions;
}
