package com.xforceplus.ant.coop.rule.center.client.data.cc.response;

import com.xforceplus.ant.coop.rule.center.client.data.cc.bean.FieldEnumValue;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * Describe: 数据模板明细 列表
 *
 * @Author xiezhongyong
 * @Date 2020-03-17
 */
@Data
public class ListDataTemplateItem {

    @ApiModelProperty("字段分组代码")
    private String fieldGroup;
    @ApiModelProperty("字段分组名称")
    private String fieldGroupName;
    @ApiModelProperty("字段分组下标")
    private Integer fieldGroupIndex;
    @ApiModelProperty("字段列表")
    private List<DataItem> dataItems;

    @Data
    public static class DataItem {
        @ApiModelProperty("数据ID")
        private String id;
        @ApiModelProperty("模板ID")
        private String templateId;
        @ApiModelProperty("字段名")
        private String fieldName;
        @ApiModelProperty("字段中文名称")
        private String fieldDisplayName;
        @ApiModelProperty("字段类型 a-多文本 s-文本 n-数值 d-日期  t-时间  l-联想")
        private String fieldType;
        @ApiModelProperty("字段格式化")
        private String fieldFormat;
        @ApiModelProperty("扩展字段标识 0-固定字段 1-扩展字段")
        private Integer extFalg;
        @ApiModelProperty("编辑标记 0-可以编辑和删除 1-可编辑,不能删除 2-不可编辑,可以删除 3-不可编辑和删除")
        private Integer editFlag;
        @ApiModelProperty("排序")
        private Integer sort;
        @ApiModelProperty("创建时间")
        private String createTime;
        @ApiModelProperty("创建人姓名")
        private String createUserName;
        @ApiModelProperty("更新时间")
        private String updateTime;
        @ApiModelProperty("更新人姓名")
        private String updateUserName;

        @ApiModelProperty("枚举值对象列表")
        private List<FieldEnumValue> fieldEnumValues;
    }
}
