package com.xforceplus.ant.coop.rule.center.client.data.cc.validation;

import com.xforceplus.ant.coop.rule.center.client.data.cc.bean.fieldlimit.FieldLimit;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bean.fieldlimit.RangeValueLimit;
import org.springframework.util.StringUtils;

/**
 * Describe: 区间值参数验证
 *
 * @Author xiezhongyong
 * @Date 2020-04-24
 */
public class RangeValueVaildation implements LimitValidation{

    @Override
    public void check(FieldLimit fieldLimit) {
        if(fieldLimit instanceof RangeValueLimit) {
            RangeValueLimit rangeValueLimit = (RangeValueLimit) fieldLimit;
            if(StringUtils.isEmpty(rangeValueLimit.getMinValue()) && !StringUtils.isEmpty(rangeValueLimit.getMaxValue())) {
                throw new RuntimeException("最小值和最大值必须同时出现");
            }
            if(!StringUtils.isEmpty(rangeValueLimit.getMinValue()) && StringUtils.isEmpty(rangeValueLimit.getMaxValue())) {
                throw new RuntimeException("最小值和最大值必须同时出现");
            }
        }
    }
}
