package com.xforceplus.ant.coop.rule.center.client.data.cc.validation;

import com.xforceplus.ant.coop.rule.center.client.data.cc.bean.fieldlimit.FieldLimit;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bean.fieldlimit.SortLimit;
import com.xforceplus.ant.coop.rule.center.client.data.cc.enums.LimitStatusEnum;
import org.springframework.util.StringUtils;

/**
 * Describe: 排序参数验证
 *
 * @Author xiezhongyong
 * @Date 2020-04-24
 */
public class SortVaildation  implements LimitValidation{

    @Override
    public void check(FieldLimit fieldLimit) {
        if(fieldLimit instanceof SortLimit) {
            SortLimit sortLimit = (SortLimit) fieldLimit;
            if(null != sortLimit.getStatus() && LimitStatusEnum.ENABLED.code().equals(sortLimit.getStatus())) {
                if(StringUtils.isEmpty(sortLimit.getSortKey())) {
                    throw new RuntimeException("启用排序时 排序key 不能为空");
                }
            }
        }
    }
}
