package com.xforceplus.ant.coop.rule.center.client.data.cc.validation;

import com.xforceplus.ant.coop.rule.center.client.data.cc.bean.fieldlimit.FieldLimit;
import com.xforceplus.ant.coop.rule.center.client.data.cc.bean.fieldlimit.TolRangeLimit;
import org.springframework.util.StringUtils;

/**
 * Describe: 容差范围参数验证
 *
 * @Author xiezhongyong
 * @Date 2020-04-24
 */
public class TolRangeVaildation implements LimitValidation{

    @Override
    public void check(FieldLimit fieldLimit) {
        if(fieldLimit instanceof TolRangeLimit) {
            TolRangeLimit tolRangeLimit = (TolRangeLimit) fieldLimit;
            if(StringUtils.isEmpty(tolRangeLimit.getMinValue()) && !StringUtils.isEmpty(tolRangeLimit.getMaxValue())) {
                throw new RuntimeException("最小值和最大值必须同时出现");
            }
            if(!StringUtils.isEmpty(tolRangeLimit.getMinValue()) && StringUtils.isEmpty(tolRangeLimit.getMaxValue())) {
                throw new RuntimeException("最小值和最大值必须同时出现");
            }
        }
    }
}
