package com.xforceplus.ant.coop.rule.center.client.data.enterprise.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 设备的基本信息
 */
@ApiModel(description = "设备的基本信息")

@JsonInclude(NON_NULL)
public class BasicDeviceInfoRequest {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("deviceUn")
  private String deviceUn = null;

  @JsonProperty("tenantId")
  private Long tenantId = null;

  @JsonProperty("tenantName")
  private String tenantName = null;

    @JsonProperty("userId")
    private Long userId = null;

    @JsonProperty("userName")
    private String userName = null;

    @JsonProperty("addDefaultTerminal")
    private String addDefaultTerminal = null;

    @JsonProperty("elConfirmPassword")
    private String elConfirmPassword = null;

  @JsonProperty("companyTaxNo")
  private String companyTaxNo = null;

  @JsonProperty("companyId")
  private Long companyId = null;

  @JsonProperty("companyName")
  private String companyName = null;

  @JsonProperty("taxDeviceNo")
  private String taxDeviceNo = null;

  @JsonProperty("deviceType")
  private String deviceType = null;

  @JsonProperty("service")
  private List<String> service = new ArrayList<String>();

  @JsonProperty("invoiceType")
  private List<String> invoiceType = new ArrayList<String>();

  @JsonProperty("nationalTaxPassword")
  private String nationalTaxPassword = null;

  @JsonProperty("taxDeviceDigitalPassword")
  private String taxDeviceDigitalPassword = null;

  @JsonProperty("taxDevicePassword")
  private String taxDevicePassword = null;

  @JsonProperty("taxDeviceType")
  private Integer taxDeviceType = null;

  @JsonProperty("taxDeviceMachineNo")
  private String taxDeviceMachineNo = null;

  @JsonProperty("showMachineNoInRemarkFlag")
  private String showMachineNoInRemarkFlag = null;

  @JsonIgnore
  public BasicDeviceInfoRequest id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * 设备主Id
   * @return id
  **/
  @ApiModelProperty(value = "设备主Id")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  @JsonIgnore
  public BasicDeviceInfoRequest deviceUn(String deviceUn) {
    this.deviceUn = deviceUn;
    return this;
  }

   /**
   * 设备联合Id
   * @return deviceUn
  **/
  @ApiModelProperty(value = "设备联合Id")
  public String getDeviceUn() {
    return deviceUn;
  }

  public void setDeviceUn(String deviceUn) {
    this.deviceUn = deviceUn;
  }

  @JsonIgnore
  public BasicDeviceInfoRequest tenantId(Long tenantId) {
    this.tenantId = tenantId;
    return this;
  }

   /**
   * 租户Id
   * @return tenantId
  **/
  @ApiModelProperty(value = "租户Id")
  public Long getTenantId() {
    return tenantId;
  }

  public void setTenantId(Long tenantId) {
    this.tenantId = tenantId;
  }

  @JsonIgnore
  public BasicDeviceInfoRequest tenantName(String tenantName) {
    this.tenantName = tenantName;
    return this;
  }
    /**
     * 是否添加默认终端 Y:是 N:否
     * @return tenantName
     **/
    @ApiModelProperty(value = "是否添加默认终端 Y:是，N:否")
    public String getAddDefaultTerminal() {
        return addDefaultTerminal;
    }

    public void setAddDefaultTerminal(String addDefaultTerminal) {
        this.addDefaultTerminal = addDefaultTerminal;
    }

    /**
   * 租户名称
   * @return tenantName
  **/
  @ApiModelProperty(value = "租户名称")
  public String getTenantName() {
    return tenantName;
  }

  public void setTenantName(String tenantName) {
    this.tenantName = tenantName;
  }

  @JsonIgnore
  public BasicDeviceInfoRequest companyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
    return this;
  }

   /**
   * 公司税号
   * @return companyTaxNo
  **/
  @ApiModelProperty(value = "公司税号")
  public String getCompanyTaxNo() {
    return companyTaxNo;
  }

  public void setCompanyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
  }

  @JsonIgnore
  public BasicDeviceInfoRequest companyId(Long companyId) {
    this.companyId = companyId;
    return this;
  }

   /**
   * 公司Id
   * @return companyId
  **/
  @ApiModelProperty(value = "公司Id")
  public Long getCompanyId() {
    return companyId;
  }

  public void setCompanyId(Long companyId) {
    this.companyId = companyId;
  }

  @JsonIgnore
  public BasicDeviceInfoRequest companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * 公司名称
   * @return companyName
  **/
  @ApiModelProperty(value = "公司名称")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  @JsonIgnore
  public BasicDeviceInfoRequest taxDeviceNo(String taxDeviceNo) {
    this.taxDeviceNo = taxDeviceNo;
    return this;
  }

   /**
   * 税盘编号
   * @return taxDeviceNo
  **/
  @ApiModelProperty(value = "税盘编号")
  public String getTaxDeviceNo() {
    return taxDeviceNo;
  }

  public void setTaxDeviceNo(String taxDeviceNo) {
    this.taxDeviceNo = taxDeviceNo;
  }

  @JsonIgnore
  public BasicDeviceInfoRequest deviceType(String deviceType) {
    this.deviceType = deviceType;
    return this;
  }

   /**
   * 设备类型, taxDevice:税盘, taxControlKey:税控钥匙UKey，taxVUKey:税控设备-VUKey
   * @return deviceType
  **/
  @ApiModelProperty(value = "设备类型, taxDevice:税盘, taxControlKey:税控钥匙UKey，taxVUKey:税控设备-VUKey")
  public String getDeviceType() {
    return deviceType;
  }

  public void setDeviceType(String deviceType) {
    this.deviceType = deviceType;
  }

  @JsonIgnore
  public BasicDeviceInfoRequest service(List<String> service) {
    this.service = service;
    return this;
  }

  public BasicDeviceInfoRequest addServiceItem(String serviceItem) {
    this.service.add(serviceItem);
    return this;
  }

   /**
   * 开通服务列表
   * @return service
  **/
  @ApiModelProperty(value = "开通服务列表")
  public List<String> getService() {
    return service;
  }

  public void setService(List<String> service) {
    this.service = service;
  }

  @JsonIgnore
  public BasicDeviceInfoRequest invoiceType(List<String> invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

  public BasicDeviceInfoRequest addInvoiceTypeItem(String invoiceTypeItem) {
    this.invoiceType.add(invoiceTypeItem);
    return this;
  }

   /**
   * 所需支持的发票类型
   * @return invoiceType
  **/
  @ApiModelProperty(value = "所需支持的发票类型")
  public List<String> getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(List<String> invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public BasicDeviceInfoRequest nationalTaxPassword(String nationalTaxPassword) {
    this.nationalTaxPassword = nationalTaxPassword;
    return this;
  }

   /**
   * 国税平台密码（底账）
   * @return nationalTaxPassword
  **/
  @ApiModelProperty(value = "国税平台密码（底账）")
  public String getNationalTaxPassword() {
    return nationalTaxPassword;
  }

  public void setNationalTaxPassword(String nationalTaxPassword) {
    this.nationalTaxPassword = nationalTaxPassword;
  }

  @JsonIgnore
  public BasicDeviceInfoRequest taxDeviceDigitalPassword(String taxDeviceDigitalPassword) {
    this.taxDeviceDigitalPassword = taxDeviceDigitalPassword;
    return this;
  }

   /**
   * 税务证书数字密码
   * @return taxDeviceDigitalPassword
  **/
  @ApiModelProperty(value = "税务证书数字密码")
  public String getTaxDeviceDigitalPassword() {
    return taxDeviceDigitalPassword;
  }

  public void setTaxDeviceDigitalPassword(String taxDeviceDigitalPassword) {
    this.taxDeviceDigitalPassword = taxDeviceDigitalPassword;
  }

  @JsonIgnore
  public BasicDeviceInfoRequest taxDevicePassword(String taxDevicePassword) {
    this.taxDevicePassword = taxDevicePassword;
    return this;
  }

   /**
   * 税盘密码
   * @return taxDevicePassword
  **/
  @ApiModelProperty(value = "税盘密码")
  public String getTaxDevicePassword() {
    return taxDevicePassword;
  }

  public void setTaxDevicePassword(String taxDevicePassword) {
    this.taxDevicePassword = taxDevicePassword;
  }

  @JsonIgnore
  public BasicDeviceInfoRequest taxDeviceType(Integer taxDeviceType) {
    this.taxDeviceType = taxDeviceType;
    return this;
  }

   /**
   * 税盘类型 1 百望单盘 2 百望服务器 3 航信单盘 4 航信服务器 5 VUKey设备 8 实体Ukey
   * @return taxDeviceType
  **/
  @ApiModelProperty(value = "税盘类型 1 百望单盘 2 百望服务器 3 航信单盘 4 航信服务器 5 VUKey设备 8 实体Ukey")
  public Integer getTaxDeviceType() {
    return taxDeviceType;
  }

  public void setTaxDeviceType(Integer taxDeviceType) {
    this.taxDeviceType = taxDeviceType;
  }

  @JsonIgnore
  public BasicDeviceInfoRequest taxDeviceMachineNo(String taxDeviceMachineNo) {
    this.taxDeviceMachineNo = taxDeviceMachineNo;
    return this;
  }

   /**
   * 税盘开票机号
   * @return taxDeviceMachineNo
  **/
  @ApiModelProperty(value = "税盘开票机号")
  public String getTaxDeviceMachineNo() {
    return taxDeviceMachineNo;
  }

  public void setTaxDeviceMachineNo(String taxDeviceMachineNo) {
    this.taxDeviceMachineNo = taxDeviceMachineNo;
  }

  @JsonIgnore
  public BasicDeviceInfoRequest showMachineNoInRemarkFlag(String showMachineNoInRemarkFlag) {
    this.showMachineNoInRemarkFlag = showMachineNoInRemarkFlag;
    return this;
  }

   /**
   * 是否在发票备注中显示开票机号
   * @return showMachineNoInRemarkFlag
  **/
  @ApiModelProperty(value = "是否在发票备注中显示开票机号")
  public String getShowMachineNoInRemarkFlag() {
    return showMachineNoInRemarkFlag;
  }

  public void setShowMachineNoInRemarkFlag(String showMachineNoInRemarkFlag) {
    this.showMachineNoInRemarkFlag = showMachineNoInRemarkFlag;
  }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getElConfirmPassword() {
        return elConfirmPassword;
    }

    public void setElConfirmPassword(String elConfirmPassword) {
        this.elConfirmPassword = elConfirmPassword;
    }

    @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BasicDeviceInfoRequest basicDeviceInfoRequest = (BasicDeviceInfoRequest) o;
    return Objects.equals(this.id, basicDeviceInfoRequest.id) &&
        Objects.equals(this.deviceUn, basicDeviceInfoRequest.deviceUn) &&
        Objects.equals(this.tenantId, basicDeviceInfoRequest.tenantId) &&
        Objects.equals(this.tenantName, basicDeviceInfoRequest.tenantName) &&
        Objects.equals(this.companyTaxNo, basicDeviceInfoRequest.companyTaxNo) &&
        Objects.equals(this.companyId, basicDeviceInfoRequest.companyId) &&
        Objects.equals(this.companyName, basicDeviceInfoRequest.companyName) &&
        Objects.equals(this.taxDeviceNo, basicDeviceInfoRequest.taxDeviceNo) &&
        Objects.equals(this.deviceType, basicDeviceInfoRequest.deviceType) &&
        Objects.equals(this.service, basicDeviceInfoRequest.service) &&
        Objects.equals(this.invoiceType, basicDeviceInfoRequest.invoiceType) &&
        Objects.equals(this.nationalTaxPassword, basicDeviceInfoRequest.nationalTaxPassword) &&
        Objects.equals(this.taxDeviceDigitalPassword, basicDeviceInfoRequest.taxDeviceDigitalPassword) &&
        Objects.equals(this.taxDevicePassword, basicDeviceInfoRequest.taxDevicePassword) &&
        Objects.equals(this.taxDeviceType, basicDeviceInfoRequest.taxDeviceType) &&
        Objects.equals(this.taxDeviceMachineNo, basicDeviceInfoRequest.taxDeviceMachineNo) &&
        Objects.equals(this.showMachineNoInRemarkFlag, basicDeviceInfoRequest.showMachineNoInRemarkFlag);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, deviceUn, tenantId, tenantName, companyTaxNo, companyId, companyName, taxDeviceNo, deviceType, service, invoiceType, nationalTaxPassword, taxDeviceDigitalPassword, taxDevicePassword, taxDeviceType, taxDeviceMachineNo, showMachineNoInRemarkFlag);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BasicDeviceInfoRequest {\n");

    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    deviceUn: ").append(toIndentedString(deviceUn)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    tenantName: ").append(toIndentedString(tenantName)).append("\n");
    sb.append("    companyTaxNo: ").append(toIndentedString(companyTaxNo)).append("\n");
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("    taxDeviceNo: ").append(toIndentedString(taxDeviceNo)).append("\n");
    sb.append("    deviceType: ").append(toIndentedString(deviceType)).append("\n");
    sb.append("    service: ").append(toIndentedString(service)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    nationalTaxPassword: ").append(toIndentedString(nationalTaxPassword)).append("\n");
    sb.append("    taxDeviceDigitalPassword: ").append(toIndentedString(taxDeviceDigitalPassword)).append("\n");
    sb.append("    taxDevicePassword: ").append(toIndentedString(taxDevicePassword)).append("\n");
    sb.append("    taxDeviceType: ").append(toIndentedString(taxDeviceType)).append("\n");
    sb.append("    taxDeviceMachineNo: ").append(toIndentedString(taxDeviceMachineNo)).append("\n");
    sb.append("    showMachineNoInRemarkFlag: ").append(toIndentedString(showMachineNoInRemarkFlag)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
