package com.xforceplus.ant.coop.rule.center.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * MsConfigAddTerminalRequest
 */

@JsonInclude(NON_NULL)
public class MsConfigAddTerminalRequest {
  @JsonProperty("opUserId")
  private Long opUserId = null;

  @JsonProperty("opUserName")
  private String opUserName = null;

  @JsonProperty("opTenantId")
  private Long opTenantId = null;

  @JsonProperty("opTenantName")
  private String opTenantName = null;

  @JsonProperty("terminalInfo")
  private MsTerminalInfo terminalInfo = null;

  @JsonIgnore
  public MsConfigAddTerminalRequest opUserId(Long opUserId) {
    this.opUserId = opUserId;
    return this;
  }

   /**
   * 操作人ID
   * @return opUserId
  **/
  @ApiModelProperty(value = "操作人ID")
  public Long getOpUserId() {
    return opUserId;
  }

  public void setOpUserId(Long opUserId) {
    this.opUserId = opUserId;
  }

  @JsonIgnore
  public MsConfigAddTerminalRequest opUserName(String opUserName) {
    this.opUserName = opUserName;
    return this;
  }

   /**
   * 操作人姓名
   * @return opUserName
  **/
  @ApiModelProperty(value = "操作人姓名")
  public String getOpUserName() {
    return opUserName;
  }

  public void setOpUserName(String opUserName) {
    this.opUserName = opUserName;
  }

  @JsonIgnore
  public MsConfigAddTerminalRequest opTenantId(Long opTenantId) {
    this.opTenantId = opTenantId;
    return this;
  }

   /**
   * 操作租户ID
   * @return opTenantId
  **/
  @ApiModelProperty(value = "操作租户ID")
  public Long getOpTenantId() {
    return opTenantId;
  }

  public void setOpTenantId(Long opTenantId) {
    this.opTenantId = opTenantId;
  }

  @JsonIgnore
  public MsConfigAddTerminalRequest opTenantName(String opTenantName) {
    this.opTenantName = opTenantName;
    return this;
  }

   /**
   * 操作租户名
   * @return opTenantName
  **/
  @ApiModelProperty(value = "操作租户名")
  public String getOpTenantName() {
    return opTenantName;
  }

  public void setOpTenantName(String opTenantName) {
    this.opTenantName = opTenantName;
  }

  @JsonIgnore
  public MsConfigAddTerminalRequest terminalInfo(MsTerminalInfo terminalInfo) {
    this.terminalInfo = terminalInfo;
    return this;
  }

   /**
   * 终端信息
   * @return terminalInfo
  **/
  @ApiModelProperty(value = "终端信息")
  public MsTerminalInfo getTerminalInfo() {
    return terminalInfo;
  }

  public void setTerminalInfo(MsTerminalInfo terminalInfo) {
    this.terminalInfo = terminalInfo;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsConfigAddTerminalRequest configAddTerminalRequest = (MsConfigAddTerminalRequest) o;
    return Objects.equals(this.opUserId, configAddTerminalRequest.opUserId) &&
        Objects.equals(this.opUserName, configAddTerminalRequest.opUserName) &&
        Objects.equals(this.opTenantId, configAddTerminalRequest.opTenantId) &&
        Objects.equals(this.opTenantName, configAddTerminalRequest.opTenantName) &&
        Objects.equals(this.terminalInfo, configAddTerminalRequest.terminalInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(opUserId, opUserName, opTenantId, opTenantName, terminalInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsConfigAddTerminalRequest {\n");

    sb.append("    opUserId: ").append(toIndentedString(opUserId)).append("\n");
    sb.append("    opUserName: ").append(toIndentedString(opUserName)).append("\n");
    sb.append("    opTenantId: ").append(toIndentedString(opTenantId)).append("\n");
    sb.append("    opTenantName: ").append(toIndentedString(opTenantName)).append("\n");
    sb.append("    terminalInfo: ").append(toIndentedString(terminalInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
