package com.xforceplus.ant.coop.rule.center.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * MsConfigTerminalLicenseKeyRequest
 */

@JsonInclude(NON_NULL)
public class MsConfigTerminalLicenseKeyRequest {
  @JsonProperty("opUserId")
  private Long opUserId = null;

  @JsonProperty("opUserName")
  private String opUserName = null;

  @JsonProperty("opTenantId")
  private Long opTenantId = null;

  @JsonProperty("unionId")
  private String unionId = null;

  @JsonProperty("terminalUn")
  private String terminalUn = null;

  @JsonIgnore
  public MsConfigTerminalLicenseKeyRequest opUserId(Long opUserId) {
    this.opUserId = opUserId;
    return this;
  }

   /**
   * 操作人ID
   * @return opUserId
  **/
  @ApiModelProperty(value = "操作人ID")
  public Long getOpUserId() {
    return opUserId;
  }

  public void setOpUserId(Long opUserId) {
    this.opUserId = opUserId;
  }

  @JsonIgnore
  public MsConfigTerminalLicenseKeyRequest opUserName(String opUserName) {
    this.opUserName = opUserName;
    return this;
  }

   /**
   * 操作人姓名
   * @return opUserName
  **/
  @ApiModelProperty(value = "操作人姓名")
  public String getOpUserName() {
    return opUserName;
  }

  public void setOpUserName(String opUserName) {
    this.opUserName = opUserName;
  }

  @JsonIgnore
  public MsConfigTerminalLicenseKeyRequest opTenantId(Long opTenantId) {
    this.opTenantId = opTenantId;
    return this;
  }

   /**
   * 操作租户ID
   * @return opTenantId
  **/
  @ApiModelProperty(value = "操作租户ID")
  public Long getOpTenantId() {
    return opTenantId;
  }

  public void setOpTenantId(Long opTenantId) {
    this.opTenantId = opTenantId;
  }

  @JsonIgnore
  public MsConfigTerminalLicenseKeyRequest unionId(String unionId) {
    this.unionId = unionId;
    return this;
  }

   /**
   * 终端unionId
   * @return unionId
  **/
  @ApiModelProperty(value = "终端unionId")
  public String getUnionId() {
    return unionId;
  }

  public void setUnionId(String unionId) {
    this.unionId = unionId;
  }

  @JsonIgnore
  public MsConfigTerminalLicenseKeyRequest terminalUn(String terminalUn) {
    this.terminalUn = terminalUn;
    return this;
  }

   /**
   * 终端联合Id
   * @return terminalUn
  **/
  @ApiModelProperty(value = "终端联合Id")
  public String getTerminalUn() {
    return terminalUn;
  }

  public void setTerminalUn(String terminalUn) {
    this.terminalUn = terminalUn;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsConfigTerminalLicenseKeyRequest configTerminalLicenseKeyRequest = (MsConfigTerminalLicenseKeyRequest) o;
    return Objects.equals(this.opUserId, configTerminalLicenseKeyRequest.opUserId) &&
        Objects.equals(this.opUserName, configTerminalLicenseKeyRequest.opUserName) &&
        Objects.equals(this.opTenantId, configTerminalLicenseKeyRequest.opTenantId) &&
        Objects.equals(this.unionId, configTerminalLicenseKeyRequest.unionId) &&
        Objects.equals(this.terminalUn, configTerminalLicenseKeyRequest.terminalUn);
  }

  @Override
  public int hashCode() {
    return Objects.hash(opUserId, opUserName, opTenantId, unionId, terminalUn);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsConfigTerminalLicenseKeyRequest {\n");

    sb.append("    opUserId: ").append(toIndentedString(opUserId)).append("\n");
    sb.append("    opUserName: ").append(toIndentedString(opUserName)).append("\n");
    sb.append("    opTenantId: ").append(toIndentedString(opTenantId)).append("\n");
    sb.append("    unionId: ").append(toIndentedString(unionId)).append("\n");
    sb.append("    terminalUn: ").append(toIndentedString(terminalUn)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
