package com.xforceplus.ant.coop.rule.center.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.ant.coop.rule.center.client.model.MsGetPlatformBySource;
import com.xforceplus.ant.coop.rule.center.client.model.MsGetPlatformConfigBySource;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 获取平台信息&amp;配置返回
 */
@ApiModel(description = "获取平台信息&配置返回")

@JsonInclude(NON_NULL)
public class MsGetPlatformConfigBySourceResult {
  @JsonProperty("platform")
  private MsGetPlatformBySource platform = null;

  @JsonProperty("platformConfig")
  private MsGetPlatformConfigBySource platformConfig = null;

  @JsonIgnore
  public MsGetPlatformConfigBySourceResult platform(MsGetPlatformBySource platform) {
    this.platform = platform;
    return this;
  }

   /**
   * 平台信息
   * @return platform
  **/
  @ApiModelProperty(value = "平台信息")
  public MsGetPlatformBySource getPlatform() {
    return platform;
  }

  public void setPlatform(MsGetPlatformBySource platform) {
    this.platform = platform;
  }

  @JsonIgnore
  public MsGetPlatformConfigBySourceResult platformConfig(MsGetPlatformConfigBySource platformConfig) {
    this.platformConfig = platformConfig;
    return this;
  }

   /**
   * 平台配置信息
   * @return platformConfig
  **/
  @ApiModelProperty(value = "平台配置信息")
  public MsGetPlatformConfigBySource getPlatformConfig() {
    return platformConfig;
  }

  public void setPlatformConfig(MsGetPlatformConfigBySource platformConfig) {
    this.platformConfig = platformConfig;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetPlatformConfigBySourceResult getPlatformConfigBySourceResult = (MsGetPlatformConfigBySourceResult) o;
    return Objects.equals(this.platform, getPlatformConfigBySourceResult.platform) &&
        Objects.equals(this.platformConfig, getPlatformConfigBySourceResult.platformConfig);
  }

  @Override
  public int hashCode() {
    return Objects.hash(platform, platformConfig);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetPlatformConfigBySourceResult {\n");
    
    sb.append("    platform: ").append(toIndentedString(platform)).append("\n");
    sb.append("    platformConfig: ").append(toIndentedString(platformConfig)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
