package com.xforceplus.ant.coop.rule.center.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 标准请求头
 */
@ApiModel(description = "标准请求头")

@JsonInclude(NON_NULL)
public class MsSortInfo {
  @JsonProperty("taxNo")
  private String taxNo = null;

  @JsonProperty("deviceNo")
  private String deviceNo = null;

  @JsonProperty("companyName")
  private String companyName = null;

  @JsonProperty("taxDeviceType")
  private String taxDeviceType = null;

  @JsonIgnore
  public MsSortInfo taxNo(String taxNo) {
    this.taxNo = taxNo;
    return this;
  }

   /**
   * 税号 （ASC 升序，DESC 降序）
   * @return taxNo
  **/
  @ApiModelProperty(value = "税号 （ASC 升序，DESC 降序）")
  public String getTaxNo() {
    return taxNo;
  }

  public void setTaxNo(String taxNo) {
    this.taxNo = taxNo;
  }

  @JsonIgnore
  public MsSortInfo deviceNo(String deviceNo) {
    this.deviceNo = deviceNo;
    return this;
  }

   /**
   * 设备编号 （ASC 升序，DESC 降序）
   * @return deviceNo
  **/
  @ApiModelProperty(value = "设备编号 （ASC 升序，DESC 降序）")
  public String getDeviceNo() {
    return deviceNo;
  }

  public void setDeviceNo(String deviceNo) {
    this.deviceNo = deviceNo;
  }

  @JsonIgnore
  public MsSortInfo companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * 公司名称 （ASC 升序，DESC 降序）
   * @return companyName
  **/
  @ApiModelProperty(value = "公司名称 （ASC 升序，DESC 降序）")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  @JsonIgnore
  public MsSortInfo taxDeviceType(String taxDeviceType) {
    this.taxDeviceType = taxDeviceType;
    return this;
  }

   /**
   * 设备类型（ASC 升序，DESC 降序）
   * @return taxDeviceType
  **/
  @ApiModelProperty(value = "设备类型（ASC 升序，DESC 降序）")
  public String getTaxDeviceType() {
    return taxDeviceType;
  }

  public void setTaxDeviceType(String taxDeviceType) {
    this.taxDeviceType = taxDeviceType;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSortInfo sortInfo = (MsSortInfo) o;
    return Objects.equals(this.taxNo, sortInfo.taxNo) &&
        Objects.equals(this.deviceNo, sortInfo.deviceNo) &&
        Objects.equals(this.companyName, sortInfo.companyName) &&
        Objects.equals(this.taxDeviceType, sortInfo.taxDeviceType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(taxNo, deviceNo, companyName, taxDeviceType);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSortInfo {\n");

    sb.append("    taxNo: ").append(toIndentedString(taxNo)).append("\n");
    sb.append("    deviceNo: ").append(toIndentedString(deviceNo)).append("\n");
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("    taxDeviceType: ").append(toIndentedString(taxDeviceType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
