package com.xforceplus.ant.coop.rule.center.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 修改平台信息
 */
@ApiModel(description = "修改平台信息")

@JsonInclude(NON_NULL)
public class MsUpdatePlatformRequest {
  @JsonProperty("source")
  private String source = null;

  @JsonProperty("platformName")
  private String platformName = null;

  @JsonProperty("restrictingAccess")
  private Integer restrictingAccess = null;

  @JsonProperty("whiteList")
  private List<String> whiteList = new ArrayList<String>();

  @JsonProperty("status")
  private Integer status = null;

  @JsonIgnore
  public MsUpdatePlatformRequest source(String source) {
    this.source = source;
    return this;
  }

   /**
   * 平台来源
   * @return source
  **/
  @ApiModelProperty(value = "平台来源")
  public String getSource() {
    return source;
  }

  public void setSource(String source) {
    this.source = source;
  }

  @JsonIgnore
  public MsUpdatePlatformRequest platformName(String platformName) {
    this.platformName = platformName;
    return this;
  }

   /**
   * 平台名称(选填)
   * @return platformName
  **/
  @ApiModelProperty(value = "平台名称(选填)")
  public String getPlatformName() {
    return platformName;
  }

  public void setPlatformName(String platformName) {
    this.platformName = platformName;
  }

  @JsonIgnore
  public MsUpdatePlatformRequest restrictingAccess(Integer restrictingAccess) {
    this.restrictingAccess = restrictingAccess;
    return this;
  }

   /**
   * 访问限制（选填）  0-不限制(默认)  1-限制
   * @return restrictingAccess
  **/
  @ApiModelProperty(value = "访问限制（选填）  0-不限制(默认)  1-限制")
  public Integer getRestrictingAccess() {
    return restrictingAccess;
  }

  public void setRestrictingAccess(Integer restrictingAccess) {
    this.restrictingAccess = restrictingAccess;
  }

  @JsonIgnore
  public MsUpdatePlatformRequest whiteList(List<String> whiteList) {
    this.whiteList = whiteList;
    return this;
  }

  public MsUpdatePlatformRequest addWhiteListItem(String whiteListItem) {
    this.whiteList.add(whiteListItem);
    return this;
  }

   /**
   * 白名单列表（选填）（IP/域名）
   * @return whiteList
  **/
  @ApiModelProperty(value = "白名单列表（选填）（IP/域名）")
  public List<String> getWhiteList() {
    return whiteList;
  }

  public void setWhiteList(List<String> whiteList) {
    this.whiteList = whiteList;
  }

  @JsonIgnore
  public MsUpdatePlatformRequest status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 平台状态（选填）  0-启用(默认)  1-停用
   * @return status
  **/
  @ApiModelProperty(value = "平台状态（选填）  0-启用(默认)  1-停用")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsUpdatePlatformRequest updatePlatformRequest = (MsUpdatePlatformRequest) o;
    return Objects.equals(this.source, updatePlatformRequest.source) &&
        Objects.equals(this.platformName, updatePlatformRequest.platformName) &&
        Objects.equals(this.restrictingAccess, updatePlatformRequest.restrictingAccess) &&
        Objects.equals(this.whiteList, updatePlatformRequest.whiteList) &&
        Objects.equals(this.status, updatePlatformRequest.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(source, platformName, restrictingAccess, whiteList, status);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsUpdatePlatformRequest {\n");
    
    sb.append("    source: ").append(toIndentedString(source)).append("\n");
    sb.append("    platformName: ").append(toIndentedString(platformName)).append("\n");
    sb.append("    restrictingAccess: ").append(toIndentedString(restrictingAccess)).append("\n");
    sb.append("    whiteList: ").append(toIndentedString(whiteList)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
