package com.xforceplus.ant.coop.rule.center.client.api;

import com.xforceplus.ant.coop.rule.center.client.model.MsGetPlatformConfigBySourceResponse;
import com.xforceplus.ant.coop.rule.center.client.model.MsGetPlatformConfigResponse;
import com.xforceplus.ant.coop.rule.center.client.model.MsResponse;
import com.xforceplus.ant.coop.rule.center.client.model.MsUpdatePlatformConfigRequest;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "platformConfigs", description = "the platformConfigs API")
public interface PlatformConfigsApi {

    @ApiOperation(value = "获取平台配置", notes = "", response = MsGetPlatformConfigResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "PlatformConfig", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "平台配置返回", response = MsGetPlatformConfigResponse.class) })
    @RequestMapping(value = "/platformConfigs/{platformId}",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     MsGetPlatformConfigResponse getPlatformConfig(@ApiParam(value = "平台ID",required=true ) @PathVariable("platformId") Long platformId);


    @ApiOperation(value = "通过source获取平台信息&配置", notes = "", response = MsGetPlatformConfigBySourceResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "PlatformConfig", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "平台信息&配置返回", response = MsGetPlatformConfigBySourceResponse.class) })
    @RequestMapping(value = "/platformConfigs/source",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     MsGetPlatformConfigBySourceResponse getPlatformConfigBySource( @NotNull @ApiParam(value = "平台source", required = true) @RequestParam(value = "source", required = true) String source);


    @ApiOperation(value = "获取枚举列表", notes = "", response = MsResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "PlatformConfig", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "统一返回", response = MsResponse.class) })
    @RequestMapping(value = "/platformConfigs/enums",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     MsResponse getPlatformConfigEnums();


    @ApiOperation(value = "更新平台配置", notes = "", response = MsResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "PlatformConfig", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "统一返回", response = MsResponse.class) })
    @RequestMapping(value = "/platformConfigs/{platformId}",
        produces = { "application/json" }, 
        method = RequestMethod.PUT)
     MsResponse updatePlatformConfig(@ApiParam(value = "平台ID",required=true ) @PathVariable("platformId") Long platformId,@ApiParam(value = "request"  ) @RequestBody MsUpdatePlatformConfigRequest request);

}
