package com.xforceplus.ant.coop.rule.center.client.api;

import java.util.List;
import com.xforceplus.ant.coop.rule.center.client.model.MsCreatePlatformRequest;
import com.xforceplus.ant.coop.rule.center.client.model.MsGetPlatformResponse;
import com.xforceplus.ant.coop.rule.center.client.model.MsListPlatformResponse;
import com.xforceplus.ant.coop.rule.center.client.model.MsResponse;
import com.xforceplus.ant.coop.rule.center.client.model.MsUpdatePlatformRequest;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "platforms", description = "the platforms API")
public interface PlatformsApi {

    @ApiOperation(value = "通过ID 删除平台信息(支持批量操作，上限20)", notes = "", response = MsResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "Platform", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "统一返回", response = MsResponse.class) })
    @RequestMapping(value = "/platforms/batch",
        produces = { "application/json" }, 
        method = RequestMethod.DELETE)
     MsResponse batchDeletePlatform(@RequestBody @ApiParam(name = "平台数据ID列表(格式：['1','2','3'])") List<Long> idList);


    @ApiOperation(value = "添加平台信息", notes = "", response = MsResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "Platform", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "统一返回", response = MsResponse.class) })
    @RequestMapping(value = "/platforms",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsResponse createPlatform(@ApiParam(value = "request"  ) @RequestBody MsCreatePlatformRequest request);


    @ApiOperation(value = "获取平台信息", notes = "", response = MsGetPlatformResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "Platform", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "平台信息返回", response = MsGetPlatformResponse.class) })
    @RequestMapping(value = "/platforms/{id}",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     MsGetPlatformResponse getPlatform(@ApiParam(value = "平台ID",required=true ) @PathVariable("id") Long id);


    @ApiOperation(value = "平台信息列表", notes = "", response = MsListPlatformResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "Platform", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "平台信息列表返回", response = MsListPlatformResponse.class) })
    @RequestMapping(value = "/platforms",
        produces = { "application/json" }, 
        method = RequestMethod.GET)
     MsListPlatformResponse listPlatform( @ApiParam(value = "页码", defaultValue = "1") @RequestParam(value = "page", required = false, defaultValue="1") Integer page, @ApiParam(value = "每页数量", defaultValue = "20") @RequestParam(value = "size", required = false, defaultValue="20") Integer size);


    @ApiOperation(value = "修改平台信息", notes = "", response = MsResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "Platform", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "统一返回", response = MsResponse.class) })
    @RequestMapping(value = "/platforms/{id}",
        produces = { "application/json" }, 
        method = RequestMethod.PUT)
     MsResponse updatePlatform(@ApiParam(value = "平台ID",required=true ) @PathVariable("id") Long id,@ApiParam(value = "request"  ) @RequestBody MsUpdatePlatformRequest request);

}
