package com.xforceplus.ant.coop.rule.center.client.api.canary;

import com.xforceplus.ant.coop.rule.center.client.data.canary.request.CreateCanaryConfig;
import com.xforceplus.ant.coop.rule.center.client.data.canary.request.UpdateCanaryConfig;
import com.xforceplus.ant.coop.rule.center.client.data.canary.response.GetCanaryConfig;
import com.xforceplus.ant.coop.rule.center.client.data.canary.response.ListCanaryConfig;
import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import com.xforceplus.ant.coop.rule.center.client.data.utils.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * Describe: 灰度配置
 *
 * @Author xiezhongyong
 * @Date 2021-10-15
 */
@Api(value = "canary-configs", description = "灰度配置 接口服务")
public interface CanaryConfigApi {

    @ApiOperation("添加灰度配置")
    @RequestMapping(value = "/canary-configs", method = RequestMethod.POST, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> create(@RequestBody @Valid CreateCanaryConfig input);

    @ApiOperation("获取灰度配置详情")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/canary-configs/{id}", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<GetCanaryConfig> get(@PathVariable("id") Long id);


    @ApiOperation("更新灰度配置")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/canary-configs/{id}", method = RequestMethod.PUT, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> update(@PathVariable("id") Long id, @RequestBody @Valid UpdateCanaryConfig input);



    @ApiOperation("删除灰度配置")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "ids", required = true, dataType = "List", paramType = "path")})
    @RequestMapping(value = "/canary-configs/{ids}", method = RequestMethod.DELETE, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> batchDelete(@PathVariable("ids") List<Long> ids);

    @ApiOperation("灰度配置列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "canaryCode", value = "灰度代码", dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "canaryName", value = "灰度名称", dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "status", value = "状态", dataType = "Integer", paramType = "query")}
    )
    @RequestMapping(value = "/canary-configs", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<Page<ListCanaryConfig>> list(@SpringQueryMap Page page,
                                            @RequestParam(value = "canaryCode", required = false) String canaryCode,
                                            @RequestParam(value = "canaryName", required = false) String canaryName,
                                            @RequestParam(value = "status", required = false) Integer status);

}
