package com.xforceplus.ant.coop.rule.center.client.api.canary;

import com.xforceplus.ant.coop.rule.center.client.data.canary.*;
import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import com.xforceplus.ant.coop.rule.center.client.data.utils.Page;
import io.swagger.annotations.*;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * Describe: 灰度路由配置
 *
 * @Author xiezhongyong
 * @Date 2021-03-15
 */
@Api(value = "canary-route-configs", description = "灰度路由配置 接口服务")
public interface CanaryRouteConfigApi {

    @ApiOperation("添加灰度路由配置")
    @RequestMapping(value = "/canary-route-configs", method = RequestMethod.POST, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> create(@RequestBody @Valid CreateCanaryRouteConfig input);

    @ApiOperation("获取灰度路由配置详情")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/canary-route-configs/{id}", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<GetCanaryRouteConfig> get(@PathVariable("id") Long id);


    @ApiOperation("更新灰度路由配置")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/canary-route-configs/{id}", method = RequestMethod.PUT, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> update(@PathVariable("id") Long id, @RequestBody @Valid UpdateCanaryRouteConfig input);


    @ApiOperation("更新灰度路由配置状态")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/canary-route-configs/{id}/status/{status}", method = RequestMethod.PUT, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> updateStatus(@PathVariable("id") Long id, @PathVariable("status") Integer status);

    @ApiOperation("删除灰度路由配置状态")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "ids", required = true, dataType = "List", paramType = "path")})
    @RequestMapping(value = "/canary-route-configs/{ids}", method = RequestMethod.DELETE, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> batchDelete(@PathVariable("ids") List<Long> ids);

    @ApiOperation("灰度路由配置列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "canaryRouteKey", value = "灰度配置标识", dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "canaryRouteName", value = "灰度配置名称", dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "canaryType", value = "灰度类型", dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "status", value = "状态", dataType = "Integer", paramType = "query")}
    )
    @RequestMapping(value = "/canary-route-configs", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<Page<ListCanaryRouteConfig>> list(@SpringQueryMap Page page,
                                                 @RequestParam(value = "canaryRouteKey", required = false) String canaryRouteKey,
                                                 @RequestParam(value = "canaryRouteName", required = false) String canaryRouteName,
                                                 @RequestParam(value = "canaryType", required = false) String canaryType,
                                                 @RequestParam(value = "status", required = false) Integer status);

    @ApiOperation("一站式入驻新增灰度路由配置")
    @RequestMapping(value = "/canary-route-configs/enter", method = RequestMethod.POST, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> addEnterConfig(@RequestBody @Valid EnterCanaryRouteConfig input);


    @ApiOperation("灰度路由type列表")
    @RequestMapping(value = "/canary-route-configs/types", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<List<ListCanaryType>> listType();
}
