package com.xforceplus.ant.coop.rule.center.client.api.cc;

import com.sun.org.apache.regexp.internal.RE;
import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import com.xforceplus.ant.coop.rule.center.client.data.cc.response.ListBillType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * Describe: 业务单类型 API
 *
 * @Author xiezhongyong
 * @Date 2020-03-09
 */
@Api(value = "bill-types", description = "业务单类型 接口服务")
public interface BillTypeApi {


    @ApiOperation("配置方业务单类型列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "configObjId", value = "配置方ID", dataType = "Long", paramType = "query", required = true),
            @ApiImplicitParam(name = "commonFalg", value = "是否查询通用业务单名(1:是，不传：否)", dataType = "Integer", paramType = "query")}
    )
    @RequestMapping(value = "/bill-types",method = RequestMethod.GET, produces = { MediaType.APPLICATION_JSON_VALUE })
    BaseResult<List<ListBillType>> list(@RequestParam(value = "configObjId") Long configObjId, @RequestParam(value = "commonFalg", required = false) Integer commonFalg);

    @ApiOperation("配置方业务单类型列表(数据模板modelTypes)")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "configObjId", value = "配置方ID", dataType = "Long", paramType = "query", required = true),
            @ApiImplicitParam(name = "modelTypes", value = "数据模板modelType列表", dataType = "List", paramType = "query", required = true),
            @ApiImplicitParam(name = "templateStatus", value = "数据模板状态(0:启用,1:停用)", dataType = "Integer", paramType = "query")}
    )
    @RequestMapping(value = "/bill-types/by-model-types",method = RequestMethod.GET, produces = { MediaType.APPLICATION_JSON_VALUE })
    BaseResult<List<ListBillType>> listByModelType(@RequestParam(value = "configObjId") Long configObjId,
                                                   @RequestParam(value = "modelTypes") List<Integer> modelTypes,
                                                   @RequestParam(value = "templateStatus", required = false) Integer templateStatus);

}
