package com.xforceplus.ant.coop.rule.center.client.api.cc;

import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import com.xforceplus.ant.coop.rule.center.client.data.cc.request.*;
import com.xforceplus.ant.coop.rule.center.client.data.cc.response.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * Describe: 购方业务模板 API
 *
 * @Author xiezhongyong
 * @Date 2020-03-31
 */
@Api(value = "biz-templates", description = "购方业务模板 接口服务")
public interface BizTemplateApi {


    @ApiOperation("业务模板列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "coopConfigId", value = "协同购方配置ID", dataType = "Long", paramType = "query", required = true),
            @ApiImplicitParam(name = "templateClassId", value = "模板分类ID", dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "applyRange", value = "适用范围 0-通用 1-限定条件", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "bindObjId", value = "关联对象ID", dataType = "Long", paramType = "query")}
    )
    @RequestMapping(value = "/biz-templates", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<List<ListBizTemplate>> list(@RequestParam(value = "coopConfigId") Long coopConfigId,
                                           @RequestParam(value = "templateClassId", required = false) Long templateClassId,
                                           @RequestParam(value = "applyRange", required = false) Integer applyRange,
                                           @RequestParam(value = "bindObjId", required = false) Long bindObjId);

    @ApiOperation("获取业务模板详情")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "模板ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/biz-templates/{id}", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<GetBizTemplate> get(@PathVariable(value = "id") Long id);


    @ApiOperation("业务模板单据类型列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "模板ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/biz-templates/{id}/bill-type", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<List<ListBillType>> listBillType(@PathVariable(value = "id") Long id);

    @ApiOperation("修改业务模板单据类型")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "模板ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/biz-templates/{id}/bill-type", method = RequestMethod.PUT, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> updateBillType(@PathVariable(value = "id") Long id, @RequestBody @Valid UpdateBizTemplateBillType input);

    @ApiOperation("修改业务模板状态")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "模板ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/biz-templates/{id}/status", method = RequestMethod.PUT, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> updateStatus(@PathVariable(value = "id") Long id, @RequestBody @Valid UpdateBizTemplateStatus input);

    @ApiOperation("修改业务模板")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "模板ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/biz-templates/{id}", method = RequestMethod.PUT, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> update(@PathVariable(value = "id") Long id, @RequestBody @Valid UpdateBizTemplate input);

    @ApiOperation("修改业务模板关联对象信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "模板ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/biz-templates/{id}/bind-obj", method = RequestMethod.PUT, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> updateBindObj(@PathVariable(value = "id") Long id, @RequestBody @Valid UpdateTemplateBindObj input);


    @ApiOperation("添加业务模板")
    @RequestMapping(value = "/biz-templates", method = RequestMethod.POST, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> create(@RequestBody @Valid CreateBizTemplate input);

}
