package com.xforceplus.ant.coop.rule.center.client.api.cc;

import com.xforceplus.ant.coop.rule.center.client.data.cc.request.ListBizTemplateDetail;
import com.xforceplus.ant.coop.rule.center.client.data.cc.request.QueryBizTemplateDetail;
import com.xforceplus.ant.coop.rule.center.client.data.cc.request.GetBizTemplateDetail;
import com.xforceplus.ant.coop.rule.center.client.data.cc.response.BizTemplateDetail;
import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.LinkedHashMap;
import java.util.List;

/**
 * Describe: 业务模板配置读取
 *
 * @Author xiezhongyong
 * @Date 2020-04-14
 */
@Api(value = "biz-template-dateils", description = "业务模板配置读取 接口服务")
public interface BizTemplateConfigApi {


    @ApiOperation("业务模板配置详情---默认返回列表结构(get)")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "configType", value = "配置类型 0-购方配置(默认) 1-供应商配置 2-渠道商配置", dataType = "int", paramType = "query", defaultValue = "0"),
            @ApiImplicitParam(name = "configObjId", value = "配置方ID", dataType = "Long", paramType = "query", defaultValue = "0"),
            @ApiImplicitParam(name = "bindObjId", value = "关联对象ID", dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "modelType", value = "模型类型", dataType = "int", paramType = "query", required = true),
            @ApiImplicitParam(name = "billTypeName", value = "业务单类型名称(有入参时必须存在当前业务单类型对应的模板，未匹配也不会返回通用模板)", dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "coopConfigClassId", value = "购方配置分类ID", dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "viewType", value = "返回数据结构类型 0：列表结构(默认)；1：分组结构", dataType = "int", paramType = "query", defaultValue = "0"),
            @ApiImplicitParam(name = "commonFlag", value = "购方未配置时是否接受通用模板 0：接受（默认）；1：不接受", dataType = "int", paramType = "query", defaultValue = "0")}
    )
    @RequestMapping(value = "/template-config/biz", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<BizTemplateDetail> getBizDetail(@RequestParam(value = "configType", required = false, defaultValue = "0") Integer configType,
                                               @RequestParam(value = "configObjId", required = false, defaultValue = "0") Long configObjId,
                                               @RequestParam(value = "bindObjId", required = false) Long bindObjId,
                                               @RequestParam(value = "modelType") Integer modelType,
                                               @RequestParam(value = "billTypeName", required = false) String billTypeName,
                                               @RequestParam(value = "coopConfigClassId", required = false) Long coopConfigClassId,
                                               @RequestParam(value = "viewType", required = false, defaultValue = "0") Integer viewType,
                                               @RequestParam(value = "commonFlag", required = false, defaultValue = "0") Integer commonFlag);

    @ApiOperation("业务模板配置详情---默认返回列表结构(post)")
    @RequestMapping(value = "/template-config/biz", method = RequestMethod.POST, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<BizTemplateDetail> getBizDetailPost(@RequestBody  @Valid GetBizTemplateDetail getBizTemplateDetail);


    @ApiOperation("业务模板配置列表查询---默认map结构(post)")
    @RequestMapping(value = "/template-config/biz/maps", method = RequestMethod.POST, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<LinkedHashMap<Long, BizTemplateDetail>> listBizDetailByMap(@RequestBody @Valid QueryBizTemplateDetail queryBizTemplateDetail);


    @ApiOperation("业务模板ID查询规则模板配置---默认返回列表结构")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "templateId", value = "数据模板ID", required = true, dataType = "Long", paramType = "path"),
            @ApiImplicitParam(name = "viewType", value = "返回数据结构类型 0:列表结构(默认)；1：分组结构", dataType = "int", paramType = "query", defaultValue = "0")})
    @RequestMapping(value = "/template-config/biz/{templateId}", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<BizTemplateDetail> getBizDetailById(@PathVariable(value = "templateId") Long dataTemplateId,
                                                   @RequestParam(value = "viewType", required = false, defaultValue = "0") Integer viewType);

    @ApiOperation("获取业务模板字段值")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "configType", value = "配置类型 0-购方配置(默认) 1-供应商配置 2-渠道商配置", dataType = "int", paramType = "query", defaultValue = "0"),
            @ApiImplicitParam(name = "configObjId", value = "配置方ID", dataType = "Long", paramType = "query", defaultValue = "0"),
            @ApiImplicitParam(name = "bindObjId", value = "关联对象ID", dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "modelType", value = "模型类型", dataType = "int", paramType = "query", required = true),
            @ApiImplicitParam(name = "billTypeName", value = "业务单类型名称(有入参时必须存在当前业务单类型对应的模板，未匹配也不会返回通用模板)", dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "coopConfigClassId", value = "购方配置分类ID", dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "commonFlag", value = "购方未配置时是否接受通用模板 0：接受（默认）；1：不接受", dataType = "int", paramType = "query", defaultValue = "0"),
            @ApiImplicitParam(name = "simpleFlag", value = "简易标识（0：只返回字段 fieldValue[0:启用；1：停用] 1：返回字段配置详细信息）", dataType = "int", paramType = "query", defaultValue = "0"),
            @ApiImplicitParam(name = "fieldName", value = "字段名", dataType = "String", paramType = "query", required = true)}
    )

    @RequestMapping(value = "/template-config/biz/field", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<Object> getBizDetailField(@RequestParam(value = "configType", required = false, defaultValue = "0") Integer configType,
                                                            @RequestParam(value = "configObjId", required = false, defaultValue = "0") Long configObjId,
                                                            @RequestParam(value = "bindObjId", required = false) Long bindObjId,
                                                            @RequestParam(value = "modelType") Integer modelType,
                                                            @RequestParam(value = "billTypeName", required = false) String billTypeName,
                                                            @RequestParam(value = "coopConfigClassId", required = false) Long coopConfigClassId,
                                                            @RequestParam(value = "commonFlag", required = false, defaultValue = "0") Integer commonFlag,
                                                            @RequestParam(value = "simpleFlag", required = false, defaultValue = "0") Integer simpleFlag,
                                                            @RequestParam(value = "fieldName") String fieldName);

}
