package com.xforceplus.ant.coop.rule.center.client.api.cc;

import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import com.xforceplus.ant.coop.rule.center.client.data.utils.Page;
import com.xforceplus.ant.coop.rule.center.client.data.cc.request.CreateCoopConfig;
import com.xforceplus.ant.coop.rule.center.client.data.cc.request.UpdateCoopConfigStatus;
import com.xforceplus.ant.coop.rule.center.client.data.cc.response.GetCoopConfig;
import com.xforceplus.ant.coop.rule.center.client.data.cc.response.ListCoopConfig;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * Describe: 协同方协同配置 API
 *
 * @Author xiezhongyong
 * @Date 2020-03-09
 */
@Api(value = "coop-configs", description = "协同配置 接口服务")
public interface CoopConfigApi {

    @ApiOperation("添加协同配置")
    @RequestMapping(value = "/coop-configs", method = RequestMethod.POST, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> create(@RequestBody @Valid CreateCoopConfig input);

    @ApiOperation("获取协同配置详情")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/coop-configs/{id}", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<GetCoopConfig> get(@PathVariable("id") Long id);

    @ApiOperation("更新协同配置状态")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/coop-configs/{id}/status", method = RequestMethod.PUT, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<String> updateStatus(@PathVariable("id") Long id, @RequestBody @Valid UpdateCoopConfigStatus input);

    @ApiOperation("协同配置列表分页")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "configType", value = "配置类型 0-购方配置 1-供应商配置 2-渠道商配置", dataType = "Integer", paramType = "query", defaultValue = "0"),
            @ApiImplicitParam(name = "coopConfigClassId", value = "协同方分类ID", dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "configObjId", value = "配置方ID", dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "status", value = "状态(0:常;1:停用)", dataType = "int", paramType = "query")}
    )
    @RequestMapping(value = "/coop-configs", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<Page<ListCoopConfig>> list(@SpringQueryMap Page page,
                                          @RequestParam(value = "configType", required = false, defaultValue = "0") Integer configType,
                                          @RequestParam(value = "coopConfigClassId", required = false) Long coopConfigClassId,
                                          @RequestParam(value = "configObjId", required = false) Long configObjId,
                                          @RequestParam(value = "status", required = false) Integer status);

    @ApiOperation("协同配置列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "configType", value = "配置类型 0-购方配置 1-供应商配置 2-渠道商配置", dataType = "Integer", paramType = "query", defaultValue = "0"),
            @ApiImplicitParam(name = "coopConfigClassId", value = "协同方分类ID", dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "configObjId", value = "配置方ID", dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "status", value = "状态(0:常;1:停用)", dataType = "int", paramType = "query")}
    )
    @RequestMapping(value = "/coop-configs/list", method = RequestMethod.GET, produces = {MediaType.APPLICATION_JSON_VALUE})
    BaseResult<Page<ListCoopConfig>> list(
                                          @RequestParam(value = "configType", required = false, defaultValue = "0") Integer configType,
                                          @RequestParam(value = "coopConfigClassId", required = false) Long coopConfigClassId,
                                          @RequestParam(value = "configObjId", required = false) Long configObjId,
                                          @RequestParam(value = "status", required = false) Integer status);
}
