package com.xforceplus.ant.coop.rule.center.client.api.cc;

import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import com.xforceplus.ant.coop.rule.center.client.data.cc.request.CreateTemplateClass;
import com.xforceplus.ant.coop.rule.center.client.data.cc.request.UpdateTemplateClass;
import com.xforceplus.ant.coop.rule.center.client.data.cc.response.ListTemplateClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * Describe: 模板分类 API
 *
 * @Author xiezhongyong
 * @Date 2020-03-11
 */
@Api(value = "coop-config-classes", description = "模板分类 接口服务")
public interface TemplateClassApi {

    @ApiOperation("添加模板分类")
    @RequestMapping(value = "/template-classes",method = RequestMethod.POST, produces = { MediaType.APPLICATION_JSON_VALUE })
    BaseResult<String> create(@RequestBody @Valid CreateTemplateClass input);

    @ApiOperation("更新模板分类状态")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "ID", required = true, dataType = "Long", paramType = "path")})
    @RequestMapping(value = "/template-classes/{id}",method = RequestMethod.PUT, produces = { MediaType.APPLICATION_JSON_VALUE })
    BaseResult<String> update(@PathVariable("id") Long id, @RequestBody @Valid UpdateTemplateClass input);

    @ApiOperation("模板分类列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "className", value = "分类名称", dataType = "String", paramType = "query")}
    )
    @RequestMapping(value = "/template-classes",method = RequestMethod.GET, produces = { MediaType.APPLICATION_JSON_VALUE })
    BaseResult<List<ListTemplateClass>> list(@RequestParam(value = "className", required = false) String className);
}
