package com.xforceplus.ant.coop.rule.center.client.api.cc;

import com.xforceplus.ant.coop.rule.center.client.data.cc.response.ListTemplateOperateLog;
import com.xforceplus.ant.coop.rule.center.client.data.utils.BaseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import java.util.List;

/**
 * Describe: 模板操作日志 API
 *
 * @Author xiezhongyong
 * @Date 2020-04-08
 */
@Api(value = "template-operate-logs", description = "模板操作日志 接口服务")
public interface TemplateOperateLogApi {

    @ApiOperation("日志列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "templateId", value = "模板ID", dataType = "Long", paramType = "query", required = true)
    })
    @RequestMapping(value = "/template-operate-logs",method = RequestMethod.GET, produces = { MediaType.APPLICATION_JSON_VALUE })
    BaseResult<List<ListTemplateOperateLog>> list(@RequestParam(value = "templateId") Long templateId);


}
