package com.xforceplus.ant.coop.rule.center.client.data.canary;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;

/**
 * Describe: 一站式入驻灰度路由配置
 *
 * @Author xiezhongyong
 * @Date 2021-03-22
 */
@Data
public class EnterCanaryRouteConfig {

    @Length(message = "灰度路由名称 最多输入100字符", max = 100)
    @NotEmpty(message = "灰度路由名称 不能为空")
    @ApiModelProperty("灰度路由名称")
    private String canaryRouteName;

    @Length(message = "灰度路由标识 最多输入50字符", max = 50)
    @NotEmpty(message = "灰度路由标识 不能为空")
    @ApiModelProperty("灰度路由标识")
    private String canaryRouteKey;

    @ApiModelProperty("灰度类型(c000:默认路由;c001:预制发票开具;c002:统一客户端")
    private String canaryType ="c000";

}
