package com.xforceplus.ant.coop.rule.center.client.data.canary.enums;


import java.util.Arrays;

/**
 * Describe:
 * c000 = 默认路由
 * c001 = 预制发票开具
 * c002 = 统一客户端
 *
 * @Author xiezhongyong
 * @Date 2021-10-25
 */
public enum CanaryTypeEnum {

    c001("c000", "默认路由"),
    c002("c001", "预制发票开具"),
    c003("c002", "统一客户端");

    private final String code;
    private final String message;

    CanaryTypeEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public String code() {
        return code;
    }

    public String message() {
        return message;
    }

    public static CanaryTypeEnum fromValue(int code) {
        return Arrays.stream(CanaryTypeEnum.values())
                .filter(s -> s.code.equals(code))
                .findAny()
                .orElse(null);
    }
}
