package com.xforceplus.ant.coop.rule.center.client.data.canary.request;

import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;

/**
 * Describe: 查询灰度协同数据
 *
 * @Author xiezhongyong
 * @Date 2021-10-21
 */
@Data
public class QueryCanaryCoordination {

    @Length(message = "灰度配置ID 最多输入20字符", max = 20)
    @NotEmpty(message = "灰度配置ID 不能为空")
    @ApiModelProperty("灰度配置ID")
    private String canaryConfigId;

    @Length(message = "购方租户ID 最多输入20字符", max = 20)
    @NotEmpty(message = "购方租户ID 不能为空")
    @ApiModelProperty("购方租户ID(0:全部购方)")
    private String purchaserTenantId = "0";

    @ApiModelProperty("销方税号")
    private String sellerTax;

    @Valid
    @ApiModelProperty("供应商筛选配置")
    private SellerSelectConfig sellerSelectConfig;

    @ApiModelProperty("供应商筛选配置(前端特供)")
    private JSONObject sellerSelectConfigExt;

    @ApiModelProperty("页码")
    private Integer page;

    @ApiModelProperty("每页数量")
    private Integer size;

}
