package com.xforceplus.ant.coop.rule.center.client.data.canary.request;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotEmpty;

/**
 * Describe: 销方筛选配置对象
 *
 * @Author xiezhongyong
 * @Date 2021-10-15
 */
@Data
@ApiModel("销方筛选配置对象")
public class SellerSelectConfig {
    @ApiModelProperty("条件类型")
    @NotEmpty(message = "条件类型 不能为空")
    private String type;
    @ApiModelProperty("下拉选项值")
    @NotEmpty(message = "下拉选项值 不能为空")
    private String value;
    @ApiModelProperty("下拉选项显示文本")
    @NotEmpty(message = "下拉选项显示文本 不能为空")
    private String text;
    @ApiModelProperty("子节点(下级下拉选项)")
    private SellerSelectConfig child;
    @ApiModelProperty("携带扩展对象")
    private JSONObject extObj;

    /**
     * 筛选配置 code 列表
     */
    @JsonIgnore
    private String sellerSelectKey;
    /**
     * 筛选配置 code 列表 描述
     */
    @JsonIgnore
    private String sellerSelectDesc;
}
